/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.item.AStr;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class Str
extends AStr {
    public static final Str WC = new Str(new byte[]{42});
    public static final Str ZERO = new Str(Token.EMPTY);

    private Str(byte[] value) {
        this(value, AtomType.STR);
    }

    public Str(byte[] value, AtomType type) {
        super(type, value);
    }

    public static Str get(byte[] value) {
        return value.length == 0 ? ZERO : new Str(value);
    }

    public static Str get(String value) {
        return Str.get(Token.token(value));
    }

    public static Str get(Object value, QueryContext qc, InputInfo inf) throws QueryException {
        boolean validate = qc.context.options.get(MainOptions.CHECKSTRINGS);
        byte[] bytes = Token.token(value.toString());
        int bl = bytes.length;
        TokenBuilder tb = null;
        int c = 0;
        while (c < bl) {
            int cp = Token.cp(bytes, c);
            if (!XMLToken.valid(cp)) {
                if (validate) {
                    throw QueryError.INVCODE_X.get(inf, Integer.toHexString(cp));
                }
                cp = 65533;
                if (tb == null) {
                    tb = new TokenBuilder(bl);
                    int b = 0;
                    while (b < c) {
                        tb.addByte(bytes[b]);
                        ++b;
                    }
                }
            }
            if (tb != null) {
                tb.add(cp);
            }
            c += Token.cl(bytes, c);
        }
        return Str.get(tb == null ? bytes : tb.finish());
    }

    @Override
    public byte[] string(InputInfo info) {
        return this.value;
    }

    public byte[] string() {
        return this.value;
    }

    @Override
    public String toJava() {
        return Token.string(this.value);
    }

    @Override
    public String toString() {
        return Str.toString(this.value);
    }
}

