/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.basex.util.Util;

public final class DateTime {
    public static final SimpleDateFormat DATETIME = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    public static final SimpleDateFormat FULL = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final SimpleDateFormat DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat TIME = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final SimpleDateFormat ZONE = new SimpleDateFormat("Z");

    static {
        FULL.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private DateTime() {
    }

    public static synchronized Date parse(String date) {
        try {
            return (date.contains(":") ? FULL : DATETIME).parse(date);
        }
        catch (ParseException ex) {
            Util.errln(ex, new Object[0]);
            return new Date(0L);
        }
    }

    public static synchronized String format(Date date) {
        return DateTime.format(date, FULL);
    }

    public static synchronized String format(Date date, DateFormat format) {
        return format.format(date);
    }
}

