/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.data.MetaProp;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

public final class InfoDB
extends AInfo {
    public InfoDB() {
        super(true, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        this.out.print(InfoDB.db(this.context.data().meta, false, true));
        return true;
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("%CONTEXT");
    }

    public static String db(MetaData meta, boolean bold, boolean index) {
        TokenBuilder tb = new TokenBuilder();
        String header = String.valueOf(bold ? new TokenBuilder().bold().add(37).norm().toString() : "%") + Text.NL;
        tb.addExt(header, Text.DB_PROPS);
        InfoDB.info(tb, MetaProp.NAME, meta);
        InfoDB.info(tb, MetaProp.SIZE.name(), Performance.format(meta.dbsize()));
        InfoDB.info(tb, MetaProp.NODES, meta);
        InfoDB.info(tb, MetaProp.DOCUMENTS, meta);
        InfoDB.info(tb, MetaProp.BINARIES, meta);
        InfoDB.info(tb, MetaProp.TIMESTAMP, meta);
        InfoDB.info(tb, MetaProp.UPTODATE, meta);
        if (meta.corrupt) {
            tb.add(String.valueOf(' ') + Text.DB_CORRUPT + Text.NL);
        }
        tb.add(Text.NL).addExt(header, Text.RES_PROPS);
        InfoDB.info(tb, MetaProp.INPUTPATH, meta);
        InfoDB.info(tb, MetaProp.INPUTSIZE.name(), Performance.format(meta.filesize));
        InfoDB.info(tb, MetaProp.INPUTDATE, meta);
        if (index) {
            tb.add(Text.NL).addExt(header, Text.INDEXES);
            if (meta.oldindex()) {
                tb.add(String.valueOf(' ') + Text.H_INDEX_FORMAT + Text.NL);
            } else {
                MetaProp[] metaPropArray = MetaProp.VALUES;
                int n = MetaProp.VALUES.length;
                int n2 = 0;
                while (n2 < n) {
                    MetaProp prop = metaPropArray[n2];
                    if (prop.index) {
                        InfoDB.info(tb, prop, meta);
                    }
                    ++n2;
                }
            }
        }
        return tb.toString();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.DB));
    }
}

