/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Pos;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnPosition;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public abstract class Cmp
extends Arr {
    final Collation coll;
    final StaticContext sc;
    boolean check = true;

    Cmp(InputInfo info, Expr expr1, Expr expr2, Collation coll, SeqType seqType, StaticContext sc) {
        super(info, seqType, expr1, expr2);
        this.coll = coll;
        this.sc = sc;
    }

    final boolean swap() {
        boolean swap;
        boolean bl = swap = this.exprs[0] instanceof Value && !(this.exprs[1] instanceof Value) || this.exprs[1] instanceof Path && ((Path)this.exprs[1]).root == null && (!(this.exprs[0] instanceof Path) || ((Path)this.exprs[0]).root != null) || this.exprs[1] instanceof FnPosition;
        if (swap) {
            Expr tmp = this.exprs[0];
            this.exprs[0] = this.exprs[1];
            this.exprs[1] = tmp;
        }
        return swap;
    }

    public abstract Expr invert(CompileContext var1) throws QueryException;

    final Expr opt(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr = this.optEqual(op, true, cc);
        if (expr == this) {
            expr = this.optFalse(op, cc);
        }
        if (expr == this) {
            expr = this.optCount(op, cc);
        }
        if (expr == this) {
            expr = this.optStringLength(op, cc);
        }
        if (expr == this) {
            expr = ItrPos.get(this, op, this.info);
        }
        if (expr == this) {
            expr = Pos.get(this, op, this.info, cc);
        }
        return expr;
    }

    final Expr optEqual(CmpV.OpV op, boolean single, CompileContext cc) {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if ((op == CmpV.OpV.EQ || single && op == CmpV.OpV.NE) && expr1.equals(expr2) && !expr1.has(Flag.NDT) && (!expr1.has(Flag.CTX) || cc.qc.focus.value != null)) {
            boolean one;
            SeqType st1 = expr1.seqType();
            Type type1 = st1.type;
            boolean bl = one = single ? st1.one() : st1.oneOrMore();
            if (one && (type1.isStringOrUntyped() || type1.instanceOf(AtomType.ITR) || type1 == AtomType.BLN)) {
                return Bln.get(op == CmpV.OpV.EQ);
            }
        }
        return this;
    }

    final Expr optFalse(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        return expr1.seqType().eq(SeqType.BLN_O) && (op == CmpV.OpV.EQ && expr2 == Bln.FALSE || op == CmpV.OpV.NE && expr2 == Bln.TRUE) ? cc.function(Function.NOT, this.info, expr1) : this;
    }

    final Expr optCount(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (!expr1.isFunction(Function.COUNT) || !(expr2 instanceof Item)) {
            return this;
        }
        Item item2 = (Item)expr2;
        if (!item2.type.isNumberOrUntyped()) {
            return this;
        }
        int type = this.check(op, item2);
        if (type >= 2) {
            Function func = type == 2 ? Function.EXISTS : Function.EMPTY;
            return cc.function(func, this.info, ((Arr)expr1).exprs);
        }
        if (type >= 0) {
            return Bln.get(type == 0);
        }
        return this;
    }

    final Expr optStringLength(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (!expr1.isFunction(Function.STRING_LENGTH) || !(expr2 instanceof Item)) {
            return this;
        }
        Item item2 = (Item)expr2;
        if (!item2.type.isNumberOrUntyped()) {
            return this;
        }
        Expr[] args = ((Arr)expr1).exprs;
        int type = this.check(op, item2);
        if (type >= 2) {
            Function func = type == 2 ? Function.BOOLEAN : Function.NOT;
            return cc.function(func, this.info, cc.function(Function.STRING, this.info, args));
        }
        if (type >= 0) {
            SeqType st1;
            Expr arg1;
            Expr expr = arg1 = args.length > 0 ? args[0] : cc.qc.focus.value;
            if (arg1 != null && ((st1 = arg1.seqType()).zero() || st1.one() && st1.type.isStringOrUntyped())) {
                return Bln.get(type == 0);
            }
        }
        return this;
    }

    private int check(CmpV.OpV op, Item item) throws QueryException {
        double v = item.dbl(this.info);
        if ((op == CmpV.OpV.GT || op == CmpV.OpV.NE) && v < 0.0 || op == CmpV.OpV.GE && v <= 0.0 || op == CmpV.OpV.NE && v != (double)((long)v)) {
            return 0;
        }
        if (op == CmpV.OpV.LT && v <= 0.0 || (op == CmpV.OpV.LE || op == CmpV.OpV.EQ) && v < 0.0 || op == CmpV.OpV.EQ && v != (double)((long)v)) {
            return 1;
        }
        if (op == CmpV.OpV.GT && v < 1.0 || op == CmpV.OpV.GE && v <= 1.0 || op == CmpV.OpV.NE && v == 0.0) {
            return 2;
        }
        if (op == CmpV.OpV.LT && v <= 1.0 || op == CmpV.OpV.LE && v < 1.0 || op == CmpV.OpV.EQ && v == 0.0) {
            return 3;
        }
        return -1;
    }
}

