/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class CmpN
extends Cmp {
    final OpN op;

    public CmpN(Expr expr1, Expr expr2, OpN op, InputInfo info) {
        super(info, expr1, expr2, null, SeqType.BLN_ZO, null);
        this.op = op;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.exprs[0].seqType().one() && this.exprs[1].seqType().one()) {
            this.exprType.assign(Occ.ONE);
        }
        return this.oneIsEmpty() ? cc.emptySeq(this) : (this.allAreValues(false) ? cc.preEval(this) : this);
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode n1 = this.toEmptyNode(this.exprs[0], qc);
        if (n1 == null) {
            return null;
        }
        ANode n2 = this.toEmptyNode(this.exprs[1], qc);
        if (n2 == null) {
            return null;
        }
        return Bln.get(this.op.eval(n1, n2));
    }

    @Override
    public CmpN invert(CompileContext cc) {
        throw Util.notExpected();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CmpN(this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op, this.info));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CmpN && this.op == ((CmpN)obj).op && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        CmpN.addPlan(plan, this.planElem("op", this.op.name), this.exprs);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpN {
        EQ("is"){

            @Override
            public boolean eval(ANode item1, ANode item2) {
                return item1.is(item2);
            }
        }
        ,
        ET("<<"){

            @Override
            public boolean eval(ANode item1, ANode item2) {
                return item1.diff(item2) < 0;
            }
        }
        ,
        GT(">>"){

            @Override
            public boolean eval(ANode item1, ANode item2) {
                return item1.diff(item2) > 0;
            }
        };

        public static final OpN[] VALUES;
        public final String name;

        static {
            VALUES = OpN.values();
        }

        private OpN(String name) {
            this.name = name;
        }

        public abstract boolean eval(ANode var1, ANode var2);

        public String toString() {
            return this.name;
        }
    }
}

