/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Simple;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class ItrPos
extends Simple {
    final long min;
    final long max;

    private ItrPos(long min, long max, InputInfo info) {
        super(info, SeqType.BLN_O);
        this.min = min;
        this.max = max;
    }

    public static Expr get(long index, InputInfo info) {
        return ItrPos.get(index, index, info);
    }

    private static Expr get(long min, long max, InputInfo info) {
        return min > max || max < 1L ? Bln.FALSE : (min <= 1L && max == Long.MAX_VALUE ? Bln.TRUE : new ItrPos(Math.max(1L, min), Math.max(1L, max), info));
    }

    public static Expr get(CmpR expr) {
        double min = expr.min;
        double max = expr.max;
        return ItrPos.get((long)Math.ceil(min), (long)Math.floor(max), expr.info);
    }

    public static Expr get(Cmp cmp, CmpV.OpV op, InputInfo info) {
        Expr cmp1 = cmp.exprs[0];
        Expr cmp2 = cmp.exprs[1];
        if (!cmp1.isFunction(Function.POSITION)) {
            return cmp;
        }
        if (cmp2 instanceof RangeSeq && op == CmpV.OpV.EQ) {
            long[] range = ((RangeSeq)cmp2).range(false);
            return ItrPos.get(range[0], range[1], info);
        }
        if (cmp2 instanceof ANum) {
            ANum item2 = (ANum)cmp2;
            long pos = item2.itr();
            boolean exact = (double)pos == item2.dbl();
            switch (op) {
                case EQ: {
                    return exact ? ItrPos.get(pos, info) : Bln.FALSE;
                }
                case GE: {
                    return ItrPos.get(exact ? pos : pos + 1L, Long.MAX_VALUE, info);
                }
                case GT: {
                    return ItrPos.get(pos + 1L, Long.MAX_VALUE, info);
                }
                case LE: {
                    return ItrPos.get(1L, pos, info);
                }
                case LT: {
                    return ItrPos.get(1L, exact ? pos - 1L : pos, info);
                }
            }
        }
        return cmp;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        return Bln.get(this.matches(qc.focus.pos));
    }

    @Override
    public ItrPos copy(CompileContext cc, IntObjMap<Var> vm) {
        return new ItrPos(this.min, this.max, this.info);
    }

    public boolean skip(long pos) {
        return pos >= this.max;
    }

    public boolean matches(long pos) {
        return pos >= this.min && pos <= this.max;
    }

    Expr intersect(ItrPos pos, InputInfo ii) {
        return ItrPos.get(Math.max(this.min, pos.min), Math.min(this.max, pos.max), ii);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItrPos)) {
            return false;
        }
        ItrPos p = (ItrPos)obj;
        return this.min == p.min && this.max == p.max;
    }

    @Override
    public void plan(FElem plan) {
        ItrPos.addPlan(plan, this.planElem("min", this.min, "max", this.max == Long.MAX_VALUE ? "inf" : Long.valueOf(this.max)), new ExprInfo[0]);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("position() ");
        if (this.min == this.max) {
            sb.append("= ").append(this.min);
        } else {
            if (this.max == Long.MAX_VALUE) {
                sb.append('>');
            }
            sb.append("= ").append(this.min);
            if (this.max != Long.MAX_VALUE) {
                sb.append(" to ").append(this.max);
            }
        }
        return sb.toString();
    }
}

