/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class List
extends Arr {
    public List(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            this.exprs[e] = this.exprs[e].compile(cc);
            ++e;
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        ExprList list = new ExprList(this.exprs.length);
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (expr != Empty.SEQ) {
                list.add(expr);
            }
            ++n2;
        }
        int ls = list.size();
        if (ls != this.exprs.length) {
            if (ls < 2) {
                return cc.replaceWith(this, ls == 0 ? Empty.SEQ : (Expr)list.get(0));
            }
            cc.info("remove % from %", Empty.SEQ, this.description());
            this.exprs = (Expr[])list.finish();
        }
        Type type = null;
        Expr[] exprArray2 = this.exprs;
        int n3 = this.exprs.length;
        int n4 = 0;
        while (n4 < n3) {
            Expr expr = exprArray2[n4];
            SeqType et = expr.seqType();
            if (!et.zero()) {
                type = type == null ? et.type : type.union(et.type);
            }
            ++n4;
        }
        long size = 0L;
        boolean zero = true;
        Expr[] exprArray3 = this.exprs;
        int n5 = this.exprs.length;
        int et = 0;
        while (et < n5) {
            Expr expr = exprArray3[et];
            long sz = expr.size();
            if (sz > 0L || expr.seqType().oneOrMore()) {
                zero = false;
            }
            if (size != -1L) {
                size = sz == -1L ? -1L : size + sz;
            }
            ++et;
        }
        this.exprType.assign(type, zero ? Occ.ZERO_MORE : Occ.ONE_MORE, size);
        if (this.allAreValues(true)) {
            Value value;
            Type tp = null;
            Value[] values = new Value[this.exprs.length];
            int vl = 0;
            Expr[] exprArray4 = this.exprs;
            int n6 = this.exprs.length;
            int sz = 0;
            while (sz < n6) {
                Expr expr = exprArray4[sz];
                cc.qc.checkStop();
                Value value2 = expr.value(cc.qc);
                if (vl == 0) {
                    tp = value2.type;
                } else if (tp != null && !tp.eq(value2.type)) {
                    tp = null;
                }
                values[vl++] = value2;
                ++sz;
            }
            sz = (int)size;
            if (tp == AtomType.STR) {
                value = StrSeq.get(values, sz);
            } else if (tp == AtomType.BLN) {
                value = BlnSeq.get(values, sz);
            } else if (tp == AtomType.FLT) {
                value = FltSeq.get(values, sz);
            } else if (tp == AtomType.DBL) {
                value = DblSeq.get(values, sz);
            } else if (tp == AtomType.DEC) {
                value = DecSeq.get(values, sz);
            } else if (tp == AtomType.BYT) {
                value = BytSeq.get(values, sz);
            } else if (tp != null && tp.instanceOf(AtomType.ITR)) {
                value = IntSeq.get(values, sz, tp);
            } else {
                ValueBuilder vb = new ValueBuilder(cc.qc);
                int v = 0;
                while (v < vl) {
                    vb.add(values[v]);
                    ++v;
                }
                value = vb.value();
            }
            return cc.replaceWith(this, value);
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            final int el;
            final long[] offsets;
            final Iter[] iters;
            long size;
            int e;
            {
                this.el = List.this.exprs.length;
                this.offsets = new long[this.el];
                this.iters = new Iter[this.el];
                this.size = Long.MIN_VALUE;
            }

            @Override
            public Item next() throws QueryException {
                while (this.e < this.el) {
                    Item item = qc.next(this.iter(this.e));
                    if (item != null) {
                        return item;
                    }
                    this.iters[this.e++] = null;
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                int o = 0;
                while (o < this.el - 1 && this.offsets[o + 1] <= i) {
                    ++o;
                }
                return this.iter(o).get(i - this.offsets[o]);
            }

            @Override
            public long size() throws QueryException {
                long size1 = 0L;
                if (this.size == Long.MIN_VALUE) {
                    int o = 0;
                    while (o < this.el && size1 != -1L) {
                        long size2 = this.iter(o).size();
                        this.offsets[o] = size1;
                        size1 = size2 == -1L || size1 + size2 < 0L ? -1L : size1 + size2;
                        ++o;
                    }
                    this.size = size1;
                }
                return size1;
            }

            private Iter iter(int i) throws QueryException {
                Iter iter = this.iters[i];
                if (iter == null) {
                    this.iters[i] = iter = List.this.exprs[i].iter(qc);
                }
                return iter;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (this.exprs.length == 2) {
            return ValueBuilder.concat(this.exprs[0].value(qc), this.exprs[1].value(qc), qc);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            vb.add(expr.value(qc));
            ++n2;
        }
        return vb.value();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new List(this.info, List.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof List && super.equals(obj);
    }

    @Override
    public boolean isVacuous() {
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (!expr.isVacuous()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String description() {
        return "expression list";
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }
}

