/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Group;
import org.basex.query.expr.gflwor.GroupSpec;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class GroupBy
extends Clause {
    private final GroupSpec[] specs;
    private Expr[] preExpr;
    private Var[] post;
    private final int nonOcc;

    public GroupBy(GroupSpec[] specs, VarRef[] pre, Var[] post, InputInfo info) {
        super(info, SeqType.ITEM_ZM, GroupBy.vars(specs, post));
        this.specs = specs;
        this.post = post;
        this.preExpr = Array.copy(pre, new Expr[pre.length]);
        int n = 0;
        GroupSpec[] groupSpecArray = specs;
        int n2 = specs.length;
        int n3 = 0;
        while (n3 < n2) {
            GroupSpec spec = groupSpecArray[n3];
            if (!spec.occluded) {
                ++n;
            }
            ++n3;
        }
        this.nonOcc = n;
    }

    private GroupBy(GroupSpec[] specs, Expr[] pre, Var[] post, int nonOcc, InputInfo info) {
        super(info, SeqType.ITEM_ZM, GroupBy.vars(specs, post));
        this.specs = specs;
        this.preExpr = pre;
        this.post = post;
        this.nonOcc = nonOcc;
    }

    private static Var[] vars(GroupSpec[] gs, Var[] vs) {
        int gl = gs.length;
        int vl = vs.length;
        Var[] res = new Var[gl + vl];
        int g = 0;
        while (g < gl) {
            res[g] = gs[g].var;
            ++g;
        }
        System.arraycopy(vs, 0, res, gl, vl);
        return res;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Group[] groups;
            private int pos;

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                if (this.groups == null) {
                    this.groups = this.init(qc);
                }
                if (this.pos == this.groups.length) {
                    return false;
                }
                Group curr = this.groups[this.pos];
                this.groups[this.pos++] = null;
                int p = 0;
                GroupSpec[] groupSpecArray = GroupBy.this.specs;
                int n = groupSpecArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GroupSpec spec = groupSpecArray[n2];
                    if (!spec.occluded) {
                        Item key = curr.key[p++];
                        qc.set(spec.var, key == null ? Empty.SEQ : key);
                    }
                    ++n2;
                }
                int pl = GroupBy.this.post.length;
                int i = 0;
                while (i < pl) {
                    qc.set(GroupBy.this.post[i], curr.ngv[i].value());
                    ++i;
                }
                return true;
            }

            private Group[] init(QueryContext qc) throws QueryException {
                ArrayList<Group> grps = new ArrayList<Group>();
                IntObjMap<Group> map = new IntObjMap<Group>();
                Collation[] colls = new Collation[GroupBy.this.nonOcc];
                int c = 0;
                GroupSpec[] groupSpecArray = GroupBy.this.specs;
                int n = groupSpecArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GroupSpec spec = groupSpecArray[n2];
                    if (!spec.occluded) {
                        colls[c++] = spec.coll;
                    }
                    ++n2;
                }
                while (sub.next(qc)) {
                    Group fst;
                    Item[] key = new Item[GroupBy.this.nonOcc];
                    int p = 0;
                    int hash = 1;
                    GroupSpec[] groupSpecArray2 = GroupBy.this.specs;
                    int n3 = groupSpecArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GroupSpec spec = groupSpecArray2[n4];
                        Item atom = spec.atomItem(qc, GroupBy.this.info);
                        if (!spec.occluded) {
                            key[p++] = atom;
                            hash = 31 * hash + (atom == null || spec.coll != null ? 0 : atom.hash(GroupBy.this.info));
                        }
                        qc.set(spec.var, atom == null ? Empty.SEQ : atom);
                        ++n4;
                    }
                    Group grp = null;
                    Group g = fst = (Group)map.get(hash);
                    while (g != null) {
                        if (GroupBy.this.eq(key, g.key, colls)) {
                            grp = g;
                            break;
                        }
                        g = g.next;
                    }
                    int pl = GroupBy.this.preExpr.length;
                    if (grp == null) {
                        ValueBuilder[] ngs = new ValueBuilder[pl];
                        int nl = ngs.length;
                        int n5 = 0;
                        while (n5 < nl) {
                            ngs[n5] = new ValueBuilder(qc);
                            ++n5;
                        }
                        grp = new Group(key, ngs);
                        grps.add(grp);
                        if (fst == null) {
                            map.put(hash, grp);
                        } else {
                            Group nxt = fst.next;
                            fst.next = grp;
                            grp.next = nxt;
                        }
                    }
                    int g2 = 0;
                    while (g2 < pl) {
                        grp.ngv[g2].add(GroupBy.this.preExpr[g2].value(qc));
                        ++g2;
                    }
                }
                return grps.toArray(new Group[grps.size()]);
            }
        };
    }

    private boolean eq(Item[] its1, Item[] its2, Collation[] coll) throws QueryException {
        int il = its1.length;
        int i = 0;
        while (i < il) {
            Item item2;
            Item item1 = its1[i];
            if (item1 == null ^ (item2 = its2[i]) == null || item1 != null && !item1.equiv(item2, coll[i], this.info)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean has(Flag ... flags) {
        GroupSpec[] groupSpecArray = this.specs;
        int n = this.specs.length;
        int n2 = 0;
        while (n2 < n) {
            GroupSpec spec = groupSpecArray[n2];
            if (spec.has(flags)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public GroupBy compile(CompileContext cc) throws QueryException {
        Expr[] exprArray = this.preExpr;
        int n = this.preExpr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            expr.compile(cc);
            ++n2;
        }
        exprArray = this.specs;
        n = this.specs.length;
        n2 = 0;
        while (n2 < n) {
            Expr spec = exprArray[n2];
            ((GroupSpec)spec).compile(cc);
            ++n2;
        }
        return this.optimize(cc);
    }

    @Override
    public GroupBy optimize(CompileContext cc) throws QueryException {
        int pl = this.preExpr.length;
        int p = 0;
        while (p < pl) {
            SeqType it = this.preExpr[p].seqType();
            this.post[p].refineType(it.with(it.occ.union(Occ.ONE_MORE)), cc);
            ++p;
        }
        SeqType st = null;
        GroupSpec[] groupSpecArray = this.specs;
        int n = this.specs.length;
        int n2 = 0;
        while (n2 < n) {
            GroupSpec spec = groupSpecArray[n2];
            st = st == null ? spec.seqType() : st.union(spec.seqType());
            ++n2;
        }
        this.exprType.assign(st);
        return this;
    }

    @Override
    public boolean removable(Var var) {
        GroupSpec[] groupSpecArray = this.specs;
        int n = this.specs.length;
        int n2 = 0;
        while (n2 < n) {
            GroupSpec b = groupSpecArray[n2];
            if (!b.removable(var)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.specs).plus(VarUsage.sum(var, this.preExpr));
    }

    @Override
    public Clause inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean b = GroupBy.inlineAll(this.specs, var, ex, cc);
        boolean p = GroupBy.inlineAll(this.preExpr, var, ex, cc);
        return b || p ? this.optimize(cc) : null;
    }

    @Override
    public GroupBy copy(CompileContext cc, IntObjMap<Var> vm) {
        Expr[] pEx = Arr.copyAll((CompileContext)cc, vm, (Expr[])this.preExpr);
        Var[] ps = new Var[this.post.length];
        int pl = ps.length;
        int p = 0;
        while (p < pl) {
            ps[p] = cc.copy(this.post[p], vm);
            ++p;
        }
        return new GroupBy((GroupSpec[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.specs), pEx, ps, this.nonOcc, this.info);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        ExprInfo ng;
        if (!GroupBy.visitAll(visitor, this.specs)) {
            return false;
        }
        ExprInfo[] exprInfoArray = this.preExpr;
        int n = this.preExpr.length;
        int n2 = 0;
        while (n2 < n) {
            ng = exprInfoArray[n2];
            if (!ng.accept(visitor)) {
                return false;
            }
            ++n2;
        }
        exprInfoArray = this.post;
        n = this.post.length;
        n2 = 0;
        while (n2 < n) {
            ng = exprInfoArray[n2];
            if (!visitor.declared((Var)ng)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    boolean clean(IntObjMap<Var> decl, BitArray used) {
        int len = this.preExpr.length;
        int p = 0;
        while (p < this.post.length) {
            if (!used.get(this.post[p].id)) {
                this.preExpr = Array.delete(this.preExpr, p);
                this.post = Array.delete(this.post, p--);
            }
            ++p;
        }
        return this.preExpr.length < len;
    }

    @Override
    boolean skippable(Clause cl) {
        return false;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.preExpr);
        this.checkNoneUp(this.specs);
    }

    @Override
    void calcSize(long[] minMax) {
        minMax[0] = Math.min(minMax[0], 1L);
    }

    @Override
    public int exprSize() {
        int size = 0;
        Expr[] exprArray = this.preExpr;
        int n = this.preExpr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        exprArray = this.specs;
        n = this.specs.length;
        n2 = 0;
        while (n2 < n) {
            Expr spec = exprArray[n2];
            size += spec.exprSize();
            ++n2;
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupBy)) {
            return false;
        }
        GroupBy g = (GroupBy)obj;
        return Array.equals(this.specs, g.specs) && Array.equals(this.preExpr, g.preExpr) && Array.equals(this.post, g.post);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        GroupSpec[] groupSpecArray = this.specs;
        int n = this.specs.length;
        int n2 = 0;
        while (n2 < n) {
            GroupSpec spec = groupSpecArray[n2];
            spec.plan(elem);
            ++n2;
        }
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int pl = this.post.length;
        int p = 0;
        while (p < pl) {
            sb.append("let").append(" (: post-group :) ").append(this.post[p]);
            sb.append(' ').append(":=").append(' ').append(this.preExpr[p]).append(' ');
            ++p;
        }
        sb.append("group").append(' ').append("by");
        int sl = this.specs.length;
        int s = 0;
        while (s < sl) {
            sb.append(s == 0 ? " " : ", ").append(this.specs[s]);
            ++s;
        }
        return sb.toString();
    }
}

