/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.core.BaseXException;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.options.Options;

public final class FuncOptions {
    public static final QNm Q_SPARAM = new QNm(QueryText.SERIALIZATION_PARAMETERS, QueryText.OUTPUT_URI);
    private static final byte[] VALUE = Token.token("value");
    private final QNm root;
    private final NodeTest test;
    private final InputInfo info;
    private boolean acceptUnknown;

    public FuncOptions(InputInfo info) {
        this(null, info);
    }

    public FuncOptions(QNm root, InputInfo info) {
        this.test = root == null ? null : new NodeTest(root);
        this.root = root;
        this.info = info;
    }

    public FuncOptions acceptUnknown() {
        this.acceptUnknown = true;
        return this;
    }

    public <T extends Options> T assign(Item item, T options) throws QueryException {
        return this.assign(item, options, QueryError.INVALIDOPT_X);
    }

    public <T extends Options> T assign(Item item, T options, QueryError error) throws QueryException {
        if (item != null) {
            TokenBuilder tb = new TokenBuilder();
            try {
                if (item instanceof Map) {
                    options.assign((Map)item, !this.acceptUnknown, this.info);
                } else {
                    if (this.test == null) {
                        throw QueryError.MAP_X_X.get(this.info, item.type, item);
                    }
                    if (!this.test.eq(item)) {
                        throw QueryError.ELMMAP_X_X_X.get(this.info, this.root.prefixId(Token.XML), item.type, item);
                    }
                    String opts = this.optString((ANode)item, error);
                    options.assign(tb.add(opts).toString());
                }
            }
            catch (BaseXException ex) {
                throw error.get(this.info, ex);
            }
        }
        return options;
    }

    private String optString(ANode node, QueryError error) throws QueryException {
        ANode n = node.attributes().next();
        if (n != null) {
            throw error.get(this.info, Util.info("Invalid attribute: '%'", new Object[]{n.name()}));
        }
        TokenBuilder tb = new TokenBuilder();
        for (ANode child : node.children()) {
            if (child.type != NodeType.ELM) continue;
            QNm qname = child.qname();
            if (!Token.eq(qname.uri(), this.root.uri())) {
                if (qname.uri().length != 0) continue;
                throw error.get(this.info, Util.info("Element has no namespace: '%'", qname));
            }
            byte[] value = null;
            String name = Token.string(qname.local());
            if (FuncOptions.hasElements(child)) {
                value = Token.token(this.optString(child, error));
            } else {
                for (ANode attr : child.attributes()) {
                    if (!Token.eq(attr.name(), VALUE)) continue;
                    value = attr.string();
                    if (!name.equals(SerializerOptions.CDATA_SECTION_ELEMENTS.name())) continue;
                    value = FuncOptions.resolve(child, value);
                }
                if (value == null) {
                    value = child.string();
                }
            }
            tb.add(name).add(61).add(Token.string(value).trim().replace(",", ",,")).add(44);
        }
        return tb.toString();
    }

    private static byte[] resolve(ANode elem, byte[] value) {
        if (!Token.contains(value, 58)) {
            return value;
        }
        TokenBuilder tb = new TokenBuilder();
        byte[][] byArray = Token.split(Token.normalize(value), 32);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] name = byArray[n2];
            int i = Token.indexOf(name, 58);
            if (i == -1) {
                tb.add(name);
            } else {
                byte[] vl = elem.nsScope(null).value(Token.substring(name, 0, i));
                if (vl != null) {
                    tb.add(QNm.eqName(vl, Token.substring(name, i + 1)));
                } else {
                    tb.add(name);
                }
            }
            tb.add(32);
            ++n2;
        }
        return tb.finish();
    }

    private static boolean hasElements(ANode node) {
        for (ANode n : node.children()) {
            if (n.type != NodeType.ELM) continue;
            return true;
        }
        return false;
    }

    public static SerializerOptions serializer(Item item, InputInfo info) throws QueryException {
        SerializerOptions so = new SerializerOptions();
        so.set(SerializerOptions.METHOD, SerialMethod.XML);
        return FuncOptions.serializer(item, so, info);
    }

    public static SerializerOptions serializer(Item item, SerializerOptions sopts, InputInfo info) throws QueryException {
        return new FuncOptions(Q_SPARAM, info).assign(item, sopts, QueryError.SEROPT_X);
    }
}

