/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.basex.core.Databases;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInput;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;
import org.basex.util.options.Options;

public abstract class StandardFunc
extends Arr {
    public static final int UNROLL_LIMIT = 10;
    public Function sig;
    public StaticContext sc;

    protected StandardFunc() {
        super(null, SeqType.ITEM_ZM, new Expr[0]);
    }

    final StandardFunc init(StaticContext sctx, InputInfo ii, Function func, Expr[] args) {
        this.sc = sctx;
        this.sig = func;
        this.info = ii;
        this.exprs = args;
        this.exprType.assign(func.seqType);
        return this;
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.opt(cc);
        return cc.replaceWith(this, expr != this ? expr : (this.preEval() ? (this.sig.seqType.zeroOrOne() ? this.item(cc.qc, this.info) : this.value(cc.qc)) : this));
    }

    protected boolean preEval() {
        return this.allAreValues(this.sig.seqType.occ.max > 1) && this.isSimple();
    }

    protected Expr opt(CompileContext cc) throws QueryException {
        return this;
    }

    @Override
    public final StandardFunc copy(CompileContext cc, IntObjMap<Var> vm) {
        int es = this.exprs.length;
        Expr[] arg = new Expr[es];
        int e = 0;
        while (e < es) {
            arg[e] = this.exprs[e].copy(cc, vm);
            ++e;
        }
        return this.copyType(this.sig.get(this.sc, this.info, arg));
    }

    protected Expr optFirst() {
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        if (st.oneOrMore() && !st.mayBeArray()) {
            this.exprType.assign(Occ.ONE);
        }
        return this;
    }

    protected final byte[] serialize(Iter iter, SerializerOptions opts, QueryError err, QueryContext qc) throws QueryException {
        try {
            ArrayOutput ao = new ArrayOutput();
            Throwable throwable = null;
            Object var7_10 = null;
            try (Serializer ser = Serializer.get(ao, opts);){
                Item item;
                while ((item = qc.next(iter)) != null) {
                    ser.serialize(item);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new TokenBuilder(ao.finish()).normalize().finish();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            throw err.get(this.info, ex);
        }
    }

    @Override
    public boolean has(Flag ... flags) {
        Flag[] flagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            Flag flag = flagArray[n2];
            if (this.sig.has(flag)) {
                return true;
            }
            ++n2;
        }
        if (Flag.UPD.in(flags) && this.sc.mixUpdates && this.sig.has(Flag.HOF)) {
            return true;
        }
        Flag[] flgs = Flag.HOF.remove(flags);
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean isFunction(Function f) {
        return this.sig == f;
    }

    @Override
    public boolean isVacuous() {
        return !this.has(Flag.UPD) && this.size() == 0L;
    }

    public void coerceFunc(int i, CompileContext cc, SeqType declType, SeqType ... argTypes) throws QueryException {
        Expr func = this.exprs[i];
        if (func instanceof FuncItem) {
            FuncItem fitem = (FuncItem)func;
            FuncType ft = fitem.funcType();
            int al = argTypes.length;
            if (al != ft.argTypes.length) {
                return;
            }
            SeqType[] fat = ft.argTypes;
            SeqType[] at = new SeqType[al];
            int a = 0;
            while (a < al) {
                at[a] = argTypes[a].instanceOf(fat[a]) ? argTypes[a] : fat[a];
                ++a;
            }
            SeqType dt = declType.instanceOf(ft.declType) ? declType : ft.declType;
            FuncType ftp = FuncType.get(dt, at);
            if (!ftp.eq(ft)) {
                fitem = fitem.coerceTo(ftp, cc.qc, this.info, true);
                ft = fitem.funcType();
                dt = fitem.expr.seqType();
                if (dt.instanceOf(ft.declType) && !(ftp = FuncType.get(dt, at)).eq(ft)) {
                    fitem = fitem.coerceTo(ftp, cc.qc, this.info, true);
                }
            }
            this.exprs[i] = fitem;
        }
    }

    protected final Expr ctxArg(int i, QueryContext qc) throws QueryException {
        return this.exprs.length == i ? this.ctxValue(qc) : this.exprs[i];
    }

    protected final DBNode toDBNode(Item item) throws QueryException {
        if (this.checkNoEmpty(item, NodeType.NOD) instanceof DBNode) {
            return (DBNode)item;
        }
        throw QueryError.DB_NODE_X.get(this.info, item);
    }

    protected final Collation toCollation(int i, QueryContext qc) throws QueryException {
        byte[] coll = i >= this.exprs.length ? null : this.toToken(this.exprs[i], qc);
        return Collation.get(coll, qc, this.sc, this.info, QueryError.WHICHCOLL_X);
    }

    protected final Path toPath(int i, QueryContext qc) throws QueryException {
        return i < this.exprs.length ? this.toPath(this.toToken(this.exprs[i], qc)) : null;
    }

    protected final Path toPath(byte[] path) throws QueryException {
        try {
            String p = Token.string(path);
            return p.startsWith("file:/") ? Paths.get(new URI(p)) : Paths.get(p, new String[0]);
        }
        catch (URISyntaxException | InvalidPathException ex) {
            Util.debug(ex);
            throw QueryError.FILE_INVALID_PATH_X.get(this.info, new Object[]{QueryError.chop(path, this.info)});
        }
    }

    protected final IO checkPath(int i, QueryContext qc) throws QueryException {
        return this.checkPath(this.toToken(this.exprs[i], qc));
    }

    protected final IO checkPath(byte[] uri) throws QueryException {
        QueryInput qi = new QueryInput(Token.string(uri), this.sc);
        if (qi.io.exists()) {
            return qi.io;
        }
        throw QueryError.WHICHRES_X.get(this.info, new Object[]{QueryError.chop(uri, this.info)});
    }

    protected final String toEncoding(int i, QueryError err, QueryContext qc) throws QueryException {
        if (i >= this.exprs.length) {
            return null;
        }
        String enc = Token.string(this.toToken(this.exprs[i], qc));
        try {
            if (Charset.isSupported(enc)) {
                return Strings.normEncoding(enc);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw err.get(this.info, enc);
    }

    protected final Item toNodeOrAtomItem(int i, QueryContext qc) throws QueryException {
        if (i >= this.exprs.length) {
            return null;
        }
        Item item = this.toItem(this.exprs[i], qc);
        return item instanceof ANode ? item : item.atomItem(qc, this.info);
    }

    protected final <E extends Options> E toOptions(int i, E opts, QueryContext qc) throws QueryException {
        return i >= this.exprs.length ? opts : new FuncOptions(this.info).assign(this.exprs[i].item(qc, this.info), opts);
    }

    protected final HashMap<String, Value> toBindings(int i, QueryContext qc) throws QueryException {
        HashMap<String, Value> hm = new HashMap<String, Value>();
        int es = this.exprs.length;
        if (i < es) {
            Item item = this.exprs[i].item(qc, this.info);
            Map map = item == null ? Map.EMPTY : this.toMap(item);
            for (Item it : map.keys()) {
                byte[] key;
                if (it.type.isStringOrUntyped()) {
                    key = it.string(null);
                } else {
                    QNm qnm = this.toQNm(it, false);
                    TokenBuilder tb = new TokenBuilder();
                    if (qnm.uri() != null) {
                        tb.add(123).add(qnm.uri()).add(125);
                    }
                    key = tb.add(qnm.local()).finish();
                }
                hm.put(Token.string(key), map.get(it, this.info));
            }
        }
        return hm;
    }

    protected final Data checkData(QueryContext qc) throws QueryException {
        String name = Token.string(this.toToken(this.exprs[0], qc));
        if (!Databases.validName(name)) {
            throw QueryError.INVDB_X.get(this.info, name);
        }
        return qc.resources.database(name, this.info);
    }

    protected final void checkAdmin(QueryContext qc) throws QueryException {
        this.checkPerm(qc, Perm.ADMIN);
    }

    protected final void checkCreate(QueryContext qc) throws QueryException {
        this.checkPerm(qc, Perm.CREATE);
    }

    private void checkPerm(QueryContext qc, Perm perm) throws QueryException {
        if (!qc.context.user().has(perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{perm, this});
        }
    }

    protected final FItem checkArity(Expr expr, int nargs, QueryContext qc) throws QueryException {
        return this.checkArity(expr, nargs, false, qc);
    }

    protected final FItem checkArity(Expr expr, int nargs, boolean updating, QueryContext qc) throws QueryException {
        FItem func = this.checkUp(this.toFunc(expr, qc), updating, this.sc);
        if (func.arity() == nargs) {
            return func;
        }
        int fargs = func.arity();
        throw QueryError.FUNARITY_X_X.get(this.info, QueryError.arguments(fargs), nargs);
    }

    protected final long dateTimeToMs(Expr expr, QueryContext qc) throws QueryException {
        Dtm dtm = (Dtm)this.checkType(expr, qc, AtomType.DTM);
        if (dtm.yea() > 292278993L) {
            throw QueryError.INTRANGE_X.get(this.info, dtm.yea());
        }
        return dtm.toJava().toGregorianCalendar().getTimeInMillis();
    }

    protected final boolean dataLock(ASTVisitor visitor, int i) {
        return visitor.lock(this.exprs[i] instanceof Str ? Token.string(((Str)this.exprs[i]).string()) : null);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof StandardFunc && this.sig == ((StandardFunc)obj).sig && super.equals(obj);
    }

    @Override
    public final String description() {
        return this.sig.toString();
    }

    @Override
    public final void plan(FElem plan) {
        StandardFunc.addPlan(plan, this.planElem("name", this.sig.desc), this.exprs);
    }

    @Override
    public final String toString() {
        return new TokenBuilder(this.sig.id()).add(40).addSep(this.exprs, ", ").add(41).toString();
    }
}

