/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.ListIterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.fn.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.EmptyArray;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public abstract class Array
extends FItem {
    static final int MIN_LEAF = 8;
    static final int MAX_LEAF = 15;
    static final int MIN_DIGIT = 4;
    static final int MAX_DIGIT = 19;
    static final int MAX_SMALL = 7;
    private Iterable<Value> iterable;

    Array() {
        super(SeqType.ANY_ARRAY, new AnnList());
    }

    public static Array empty() {
        return EmptyArray.INSTANCE;
    }

    public static Array singleton(Value elem) {
        return new SmallArray(new Value[]{elem});
    }

    @SafeVarargs
    public static Array from(Value ... values) {
        ArrayBuilder builder = new ArrayBuilder();
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            builder.append(value);
            ++n2;
        }
        return builder.freeze();
    }

    public abstract Array cons(Value var1);

    public abstract Array snoc(Value var1);

    public abstract Value get(long var1);

    public abstract Array put(long var1, Value var3);

    public abstract long arraySize();

    public abstract Array concat(Array var1);

    public abstract Value head();

    public abstract Value last();

    public abstract Array init();

    public abstract Array tail();

    public abstract Array subArray(long var1, long var3, QueryContext var5);

    public abstract Array reverseArray(QueryContext var1);

    public abstract boolean isEmptyArray();

    public abstract Array insertBefore(long var1, Value var3, QueryContext var4);

    public abstract Array remove(long var1, QueryContext var3);

    @Override
    public final void materialize(InputInfo info) throws QueryException {
        for (Value value : this.members()) {
            value.materialize(info);
        }
    }

    public abstract ListIterator<Value> iterator(long var1);

    public final Iterable<Value> members() {
        if (this.iterable == null) {
            this.iterable = () -> this.iterator(0L);
        }
        return this.iterable;
    }

    abstract Array consSmall(Value[] var1);

    static Value[] slice(Value[] values, int from, int to) {
        Value[] out = new Value[to - from];
        int in0 = Math.max(0, from);
        int in1 = Math.min(to, values.length);
        int out0 = Math.max(-from, 0);
        System.arraycopy(values, in0, out, out0, in1 - in0);
        return out;
    }

    static Value[] concat(Value[] values1, Value[] values2) {
        int l = values1.length;
        int r = values2.length;
        int n = l + r;
        Value[] out = new Value[n];
        System.arraycopy(values1, 0, out, 0, l);
        System.arraycopy(values2, 0, out, l, r);
        return out;
    }

    abstract void checkInvariants();

    @Override
    public final Value invValue(QueryContext qc, InputInfo info, Value ... args) throws QueryException {
        Item key = args[0].atomItem(qc, info);
        if (key == null) {
            throw QueryError.EMPTYFOUND_X.get(info, AtomType.ITR);
        }
        return this.get(key, info);
    }

    @Override
    public final Item invItem(QueryContext qc, InputInfo info, Value ... args) throws QueryException {
        return this.invValue(qc, info, args).item(qc, info);
    }

    public final Value get(Item key, InputInfo info) throws QueryException {
        if (!key.type.instanceOf(AtomType.ITR) && !key.type.isUntyped()) {
            throw QueryError.typeError(key, AtomType.ITR, info);
        }
        long pos = key.itr(info);
        long size = this.arraySize();
        if (pos > 0L && pos <= size) {
            return this.get(pos - 1L);
        }
        throw (size == 0L ? QueryError.ARRAYEMPTY : QueryError.ARRAYBOUNDS_X_X).get(info, pos, size);
    }

    @Override
    public final int stackFrameSize() {
        return 0;
    }

    @Override
    public final int arity() {
        return 1;
    }

    @Override
    public final QNm funcName() {
        return null;
    }

    @Override
    public final QNm paramName(int pos) {
        return new QNm("pos", "");
    }

    @Override
    public final FuncType funcType() {
        return ArrayType.get(SeqType.ITEM_ZM);
    }

    @Override
    public final Expr inlineExpr(Expr[] exprs, CompileContext cc, InputInfo info) {
        return null;
    }

    @Override
    public final boolean isVacuousBody() {
        return false;
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo info) throws QueryException {
        if (this.arraySize() == 1L) {
            return this.get(0L).atomValue(qc, info);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Value value : this.members()) {
            vb.add(value.atomValue(qc, info));
        }
        return vb.value();
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo info) throws QueryException {
        if (this.atomSize() > 1L) {
            throw QueryError.SEQFOUND_X.get(info, this);
        }
        Value value = this.atomValue(qc, info);
        return value.isEmpty() ? null : (Item)value;
    }

    @Override
    public final long atomSize() {
        long size = 0L;
        for (Value value : this.members()) {
            for (Item item : value) {
                size += item.atomSize();
            }
        }
        return size;
    }

    public final void string(boolean indent, TokenBuilder tb, int level, InputInfo info) throws QueryException {
        tb.add(91);
        int c = 0;
        for (Value value : this.members()) {
            long vs;
            if (c++ > 0) {
                tb.add(44);
                if (indent) {
                    tb.add(32);
                }
            }
            if ((vs = value.size()) != 1L) {
                tb.add(40);
            }
            int cc = 0;
            int i = 0;
            while ((long)i < vs) {
                Item item;
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if ((item = value.itemAt(i)) instanceof Array) {
                    ((Array)item).string(indent, tb, level, info);
                } else if (item instanceof Map) {
                    ((Map)item).string(indent, tb, level + 1, info);
                } else {
                    tb.add(item.toString());
                }
                ++i;
            }
            if (vs == 1L) continue;
            tb.add(41);
        }
        tb.add(93);
    }

    @Override
    public final boolean instanceOf(Type tp) {
        return tp == AtomType.ITEM || tp instanceof FuncType && this.instanceOf((FuncType)tp, false);
    }

    @Override
    public final FItem coerceTo(FuncType ft, QueryContext qc, InputInfo info, boolean opt) throws QueryException {
        if (this.instanceOf(ft, true)) {
            return this;
        }
        throw QueryError.typeError(this, ft, info);
    }

    private boolean instanceOf(FuncType ft, boolean coerce) {
        if (ft instanceof MapType) {
            return false;
        }
        if (this.type.instanceOf(ft)) {
            return true;
        }
        SeqType[] at = ft.argTypes;
        if (!(at == null || at.length == 1 && at[0].instanceOf(SeqType.ITR_O))) {
            return false;
        }
        SeqType ret = ft.declType;
        if (ft instanceof ArrayType) {
            if (ret.eq(SeqType.ITEM_ZM)) {
                return true;
            }
            for (Value value : this.members()) {
                if (ret.instance(value)) continue;
                return false;
            }
            return true;
        }
        return coerce || ret.eq(SeqType.ITEM_ZM);
    }

    @Override
    public final boolean deep(Item item, InputInfo info, Collation coll) throws QueryException {
        if (item instanceof Array) {
            Array o = (Array)item;
            if (this.arraySize() != o.arraySize()) {
                return false;
            }
            ListIterator<Value> iter1 = this.iterator(0L);
            ListIterator<Value> iter2 = o.iterator(0L);
            while (iter1.hasNext()) {
                Value value1 = (Value)iter1.next();
                Value value2 = (Value)iter2.next();
                if (value1.size() == value2.size() && new DeepEqual(info).collation(coll).equal(value1, value2)) continue;
                return false;
            }
            return true;
        }
        return item instanceof FItem && !(item instanceof Map) && super.deep(item, info, coll);
    }

    @Override
    public final String description() {
        return "array";
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public final void plan(FElem plan) {
        long size = this.arraySize();
        FElem elem = this.planElem("entries", size, "type", this.seqType());
        int max = (int)Math.min(size, 5L);
        int i = 0;
        while (i < max) {
            this.get(i).plan(elem);
            ++i;
        }
        Array.addPlan(plan, elem, new ExprInfo[0]);
    }

    public final Object[] toJava() throws QueryException {
        long size = this.arraySize();
        Object[] tmp = new Object[(int)size];
        ListIterator<Value> iter = this.iterator(0L);
        int i = 0;
        while (iter.hasNext()) {
            tmp[i] = ((Value)iter.next()).toJava();
            ++i;
        }
        return tmp;
    }

    @Override
    public final String toString() {
        StringBuilder tb = new StringBuilder().append("[ ");
        ListIterator<Value> iter = this.iterator(0L);
        boolean fst = true;
        while (iter.hasNext()) {
            Value value;
            long vs;
            if (!fst) {
                tb.append(", ");
            }
            if ((vs = (value = (Value)iter.next()).size()) != 1L) {
                tb.append('(');
            }
            int i = 0;
            while ((long)i < vs) {
                if (i != 0) {
                    tb.append(", ");
                }
                tb.append(value.itemAt(i));
                ++i;
            }
            if (vs != 1L) {
                tb.append(')');
            }
            fst = false;
        }
        return tb.append(" ]").toString();
    }
}

