/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Dbl
extends ANum {
    public static final Dbl NAN = new Dbl(Double.NaN);
    public static final Dbl ZERO = new Dbl(0.0);
    public static final Dbl ONE = new Dbl(1.0);
    private final double value;

    private Dbl(double value) {
        super(AtomType.DBL);
        this.value = value;
    }

    public static Dbl get(double value) {
        return value == 0.0 && Double.doubleToRawLongBits(value) == 0L ? ZERO : (value == 1.0 ? ONE : (Double.isNaN(value) ? NAN : new Dbl(value)));
    }

    public static Dbl get(byte[] value, InputInfo info) throws QueryException {
        return Dbl.get(Dbl.parse(value, info));
    }

    @Override
    public byte[] string() {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo info) {
        return !Double.isNaN(this.value) && this.value != 0.0;
    }

    @Override
    public long itr() {
        return (long)this.value;
    }

    @Override
    public float flt() {
        return (float)this.value;
    }

    @Override
    public double dbl() {
        return this.value;
    }

    @Override
    public BigDecimal dec(InputInfo info) throws QueryException {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            throw QueryError.valueError(AtomType.DEC, this.string(), info);
        }
        return new BigDecimal(this.value);
    }

    @Override
    public Dbl abs() {
        return this.value > 0.0 || 1.0 / this.value > 0.0 ? this : Dbl.get(-this.value);
    }

    @Override
    public Dbl ceiling() {
        double d = Math.ceil(this.value);
        return d == this.value ? this : Dbl.get(d);
    }

    @Override
    public Dbl floor() {
        double d = Math.floor(this.value);
        return d == this.value ? this : Dbl.get(d);
    }

    @Override
    public Dbl round(int scale, boolean even) {
        double v = this.rnd(scale, even);
        return v == this.value ? this : Dbl.get(v);
    }

    private double rnd(int s, boolean e) {
        double v;
        block7: {
            double r;
            double f;
            boolean n;
            block6: {
                v = this.value;
                if (v == 0.0 || Double.isNaN(v) || Double.isInfinite(v) || s > 322) {
                    return v;
                }
                if (s < -308) {
                    return 0.0;
                }
                if (!e && s == 0) {
                    if (v >= -0.5 && v < 0.0) {
                        return -0.0;
                    }
                    if (v > -9.223372036854776E18 && v < 9.223372036854776E18) {
                        return Math.round(v);
                    }
                }
                if (!Double.isInfinite(v = ((n = v < 0.0) ? -v : v) * (f = StrictMath.pow(10.0, s + 1)))) break block6;
                RoundingMode m = e ? RoundingMode.HALF_EVEN : RoundingMode.HALF_UP;
                v = new BigDecimal(this.value).setScale(s, m).doubleValue();
                break block7;
            }
            v += (r = v % 10.0) < 5.0 ? -r : ((e ? r > 5.0 : r >= 5.0) ? 10.0 - r : (double)(e ? (v % 20.0 == 15.0 ? 5 : -5) : 0));
            v /= f;
            if (n) {
                v = -v;
            }
        }
        return v;
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        return this.value == item.dbl(info);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        double n = item.dbl(info);
        return Double.isNaN(n) || Double.isNaN(this.value) ? Integer.MIN_VALUE : (this.value < n ? -1 : (this.value > n ? 1 : 0));
    }

    @Override
    public Double toJava() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Dbl && this.value == ((Dbl)obj).value || this == NAN && obj == NAN;
    }

    public static double parse(Item item, InputInfo info) throws QueryException {
        Double d = Dbl.parse(item.string(info));
        if (d != null) {
            return d;
        }
        throw AtomType.DBL.castError(item, info);
    }

    public static double parse(byte[] value, InputInfo info) throws QueryException {
        Double d = Dbl.parse(value);
        if (d != null) {
            return d;
        }
        throw AtomType.DBL.castError(value, info);
    }

    private static Double parse(byte[] value) {
        double d = Token.toDouble(value);
        if (!Double.isNaN(d)) {
            return d;
        }
        byte[] v = Token.trim(value);
        if (Token.eq(v, Token.NAN)) {
            return Double.NaN;
        }
        if (Token.eq(v, Token.INF)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Token.eq(v, Token.NINF)) {
            return Double.NEGATIVE_INFINITY;
        }
        return null;
    }
}

