/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieBranch;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

final class TrieList
extends TrieNode {
    final int hash;
    final Item[] keys;
    final Value[] values;

    TrieList(int hash, Item[] keys, Value[] values) {
        super(keys.length);
        this.keys = keys;
        this.values = values;
        this.hash = hash;
        assert (this.verify());
    }

    TrieList(int hash, Item key1, Value value1, Item key2, Value value2) {
        this(hash, new Item[]{key1, key2}, new Value[]{value1, value2});
    }

    @Override
    TrieNode delete(int hs, Item key, int level, InputInfo info) throws QueryException {
        if (hs == this.hash) {
            int i = this.size;
            while (i-- > 0) {
                if (!key.sameKey(this.keys[i], info)) continue;
                if (this.size == 2) {
                    int o = i ^ 1;
                    return new TrieLeaf(hs, this.keys[o], this.values[o]);
                }
                int s = this.size - 1;
                Item[] ks = new Item[s];
                System.arraycopy(this.keys, 0, ks, 0, i);
                System.arraycopy(this.keys, i + 1, ks, i, s - i);
                Value[] vs = new Value[s];
                System.arraycopy(this.values, 0, vs, 0, i);
                System.arraycopy(this.values, i + 1, vs, i, s - i);
                return new TrieList(hs, ks, vs);
            }
        }
        return this;
    }

    @Override
    TrieNode put(int hs, Item key, Value value, int level, InputInfo info) throws QueryException {
        int used;
        int b;
        if (hs == this.hash) {
            int i = this.keys.length;
            while (i-- > 0) {
                if (!key.sameKey(this.keys[i], info)) continue;
                Value[] vs = (Value[])this.values.clone();
                vs[i] = value;
                return new TrieList(hs, this.keys, vs);
            }
            return new TrieList(this.hash, Array.add(this.keys, key), Array.add(this.values, value));
        }
        TrieNode[] ch = new TrieNode[32];
        int a = TrieList.key(hs, level);
        if (a == (b = TrieList.key(this.hash, level))) {
            ch[a] = this.put(hs, key, value, level + 1, info);
            used = 1 << a;
        } else {
            ch[a] = new TrieLeaf(hs, key, value);
            ch[b] = this;
            used = 1 << a | 1 << b;
        }
        return new TrieBranch(ch, used, this.size + 1);
    }

    @Override
    Value get(int hs, Item key, int level, InputInfo info) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!key.sameKey(this.keys[k], info)) continue;
                return this.values[k];
            }
        }
        return null;
    }

    @Override
    boolean contains(int hs, Item key, int level, InputInfo info) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!key.sameKey(this.keys[k], info)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    TrieNode addAll(TrieNode node, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        return node.add(this, level, merge, info, qc);
    }

    @Override
    TrieNode add(TrieLeaf leaf, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == leaf.hash) {
            int k = this.keys.length;
            while (k-- > 0) {
                if (!leaf.key.sameKey(this.keys[k], info)) continue;
                switch (merge) {
                    case USE_FIRST: 
                    case UNSPECIFIED: {
                        Value[] uf = (Value[])this.values.clone();
                        uf[k] = leaf.value;
                        return new TrieList(this.hash, this.keys, uf);
                    }
                    case USE_LAST: {
                        return this;
                    }
                    case COMBINE: {
                        Value[] cm = (Value[])this.values.clone();
                        cm[k] = ValueBuilder.concat(leaf.value, cm[k], qc);
                        return new TrieList(this.hash, this.keys, cm);
                    }
                }
                throw QueryError.MERGE_DUPLICATE_X.get(info, leaf.key);
            }
            return new TrieList(this.hash, Array.add(this.keys, leaf.key), Array.add(this.values, leaf.value));
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieList.key(this.hash, level);
        if (k == (ok = TrieList.key(leaf.hash, level))) {
            ch[k] = this.add(leaf, level + 1, merge, info, qc);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = leaf;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, this.size + 1);
    }

    @Override
    TrieNode add(TrieList list, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == list.hash) {
            Item[] ks = this.keys;
            Value[] vs = this.values;
            int i = 0;
            while (i < this.size) {
                block6: {
                    Item ok2 = list.keys[i];
                    Item[] itemArray = this.keys;
                    int n = this.keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Item k = itemArray[n2];
                        if (!k.sameKey(ok2, info)) {
                            ++n2;
                            continue;
                        }
                        break block6;
                    }
                    ks = Array.add(ks, ok2);
                    vs = Array.add(vs, list.values[i]);
                }
                ++i;
            }
            return ks == this.keys ? this : new TrieList(this.hash, ks, vs);
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieList.key(this.hash, level);
        if (k == (ok = TrieList.key(list.hash, level))) {
            ch[k] = this.add(list, level + 1, merge, info, qc);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = list;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, this.size + list.size);
    }

    @Override
    TrieNode add(TrieBranch branch, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        int k = TrieList.key(this.hash, level);
        TrieNode[] ch = branch.copyKids();
        TrieNode old = ch[k];
        TrieNode trieNode = old == null ? this : old.addAll(this, level + 1, merge, info, qc);
        ch[k] = trieNode;
        return new TrieBranch(ch, branch.used | 1 << k, branch.size + this.size - (old != null ? old.size : 0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean verify() {
        try {
            int i = 1;
            block2: while (true) {
                if (i >= this.size) {
                    return true;
                }
                int j = i;
                do {
                    if (j-- > 0) continue;
                    ++i;
                    continue block2;
                } while (!this.keys[i].sameKey(this.keys[j], null));
                break;
            }
            return false;
        }
        catch (QueryException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    void keys(ItemList ks) {
        Item[] itemArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            Item key = itemArray[n2];
            ks.add(key);
            ++n2;
        }
    }

    @Override
    void values(ValueBuilder vs) {
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            vs.add(value);
            ++n2;
        }
    }

    @Override
    void materialize(InputInfo info) throws QueryException {
        int i = 0;
        while (i < this.size) {
            this.keys[i].materialize(info);
            this.values[i].materialize(info);
            ++i;
        }
    }

    @Override
    void forEach(ValueBuilder vb, FItem func, QueryContext qc, InputInfo info) throws QueryException {
        int i = 0;
        while (i < this.size) {
            vb.add(func.invokeValue(qc, info, this.keys[i], this.values[i]));
            ++i;
        }
    }

    @Override
    boolean instanceOf(AtomType kt, SeqType dt) {
        int n;
        int n2;
        Value[] valueArray;
        if (kt != null) {
            valueArray = this.keys;
            n2 = this.keys.length;
            n = 0;
            while (n < n2) {
                Value key = valueArray[n];
                if (!((Item)key).type.instanceOf(kt)) {
                    return false;
                }
                ++n;
            }
        }
        if (dt != null) {
            valueArray = this.values;
            n2 = this.values.length;
            n = 0;
            while (n < n2) {
                Value value = valueArray[n];
                if (!dt.instance(value)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    @Override
    int hash(InputInfo info) throws QueryException {
        int h = this.hash;
        int i = this.size;
        while (--i >= 0) {
            h ^= this.values[i].hash(info);
        }
        return h;
    }

    @Override
    boolean deep(InputInfo info, TrieNode node, Collation coll) throws QueryException {
        if (!(node instanceof TrieList) || this.size != node.size) {
            return false;
        }
        TrieList ol = (TrieList)node;
        int i = 0;
        while (i < this.size) {
            block5: {
                Item k = this.keys[i];
                int j = 0;
                while (j < this.size) {
                    if (k.sameKey(ol.keys[j], info)) {
                        if (!TrieList.deep(this.values[i], ol.values[j], coll, info)) {
                            return false;
                        }
                        break block5;
                    }
                    ++j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    StringBuilder append(StringBuilder sb, String indent) {
        sb.append(indent).append("`-- Collision (").append(Integer.toHexString(this.hash)).append("):\n");
        int kl = this.keys.length;
        int k = 0;
        while (k < kl) {
            sb.append(indent).append("      ").append(this.keys[k]).append(" => ");
            sb.append(this.values[k]).append('\n');
            ++k;
        }
        return sb;
    }

    @Override
    StringBuilder append(StringBuilder sb) {
        int i = this.size;
        while (--i >= 0 && TrieList.more(sb)) {
            sb.append(this.keys[i]).append(": ").append(this.values[i]).append(", ");
        }
        return sb;
    }
}

