/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.Objects;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FNSpace;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class FElem
extends FNode {
    public static final FElem DUMMY = new FElem("");
    private final QNm name;
    private ANodeList children;
    private ANodeList atts;
    private Atts ns;

    public FElem(String name) {
        this(Token.token(name));
    }

    public FElem(byte[] name) {
        this(new QNm(name));
    }

    public FElem(byte[] local, byte[] uri) {
        this(Token.EMPTY, local, uri);
    }

    public FElem(String local, String uri) {
        this(Token.EMPTY, Token.token(local), Token.token(uri));
    }

    public FElem(String prefix, String local, String uri) {
        this(Token.token(prefix), Token.token(local), Token.token(uri));
    }

    public FElem(byte[] prefix, byte[] local, byte[] uri) {
        this(new QNm(prefix, local, uri));
    }

    public FElem(QNm name) {
        this(name, null, null, null);
    }

    public FElem(QNm name, Atts ns, ANodeList children, ANodeList atts) {
        super(NodeType.ELM);
        this.name = name;
        this.children = children;
        this.atts = atts;
        this.ns = ns;
    }

    public FElem(Element elem, ANode parent, TokenMap nss) {
        super(NodeType.ELM);
        Object nm;
        this.parent = parent;
        String nu = elem.getNamespaceURI();
        this.name = new QNm(elem.getNodeName(), nu == null ? Token.EMPTY : Token.token(nu));
        this.ns = new Atts();
        NamedNodeMap at = elem.getAttributes();
        int as = at.getLength();
        int i = 0;
        while (i < as) {
            Attr att = (Attr)at.item(i);
            nm = Token.token(att.getName());
            byte[] uri = Token.token(att.getValue());
            if (Token.eq((byte[])nm, Token.XMLNS)) {
                this.ns.add(Token.EMPTY, uri);
            } else if (Token.startsWith((byte[])nm, Token.XMLNSC)) {
                this.ns.add(Token.local((byte[])nm), uri);
            } else {
                this.add(new FAttr(att));
            }
            ++i;
        }
        int nl = this.ns.size();
        int n = 0;
        while (n < nl) {
            nss.put(this.ns.name(n), this.ns.value(n));
            ++n;
        }
        if (parent == null) {
            FElem.nsScope(elem.getParentNode(), nss);
            nm = nss.iterator();
            while (nm.hasNext()) {
                byte[] pref = (byte[])nm.next();
                if (this.ns.contains(pref)) continue;
                this.ns.add(pref, nss.get(pref));
            }
        }
        byte[] pref = this.name.prefix();
        byte[] uri = this.name.uri();
        byte[] old = nss.get(pref);
        if (old == null || !Token.eq(uri, old)) {
            this.ns.add(pref, uri);
            nss.put(pref, uri);
        }
        NodeList ch = elem.getChildNodes();
        int i2 = 0;
        while (i2 < ch.getLength()) {
            Node child = ch.item(i2);
            switch (child.getNodeType()) {
                case 3: {
                    this.add(new FTxt((Text)child));
                    break;
                }
                case 8: {
                    this.add(new FComm((Comment)child));
                    break;
                }
                case 7: {
                    this.add(new FPI((ProcessingInstruction)child));
                    break;
                }
                case 1: {
                    this.add(new FElem((Element)child, this, nss));
                    break;
                }
            }
            ++i2;
        }
        this.optimize();
    }

    private static void nsScope(Node elem, TokenMap nss) {
        Node n = elem;
        while (n instanceof Element) {
            NamedNodeMap atts = n.getAttributes();
            byte[] pref = Token.token(n.getPrefix());
            if (nss.get(pref) != null) {
                nss.put(pref, Token.token(n.getNamespaceURI()));
            }
            int len = atts.getLength();
            int i = 0;
            while (i < len) {
                byte[] ln;
                Attr a = (Attr)atts.item(i);
                byte[] name = Token.token(a.getName());
                byte[] val = Token.token(a.getValue());
                if (Token.eq(name, Token.XMLNS)) {
                    if (nss.get(Token.EMPTY) == null) {
                        nss.put(Token.EMPTY, val);
                    }
                } else if (Token.startsWith(name, Token.XMLNS) && nss.get(ln = Token.local(name)) == null) {
                    nss.put(ln, val);
                }
                ++i;
            }
            n = n.getParentNode();
        }
    }

    @Override
    public FElem optimize() {
        if (this.children != null) {
            for (ANode n : this.children) {
                n.parent(this);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
        if (this.atts != null) {
            for (ANode n : this.atts) {
                n.parent(this);
            }
            if (this.atts.isEmpty()) {
                this.atts = null;
            }
        }
        if (this.ns != null && this.ns.isEmpty()) {
            this.ns = null;
        }
        return this;
    }

    public FElem declareNS() {
        this.namespaces().add(this.name.prefix(), this.name.uri());
        return this;
    }

    public FElem add(ANode node) {
        if (node.type == NodeType.ATT) {
            if (this.atts == null) {
                this.atts = new ANodeList(node);
            } else {
                this.atts.add(node);
            }
        } else if (this.children == null) {
            this.children = new ANodeList(node);
        } else {
            this.children.add(node);
        }
        node.parent(this);
        return this;
    }

    public FElem add(String nm, String val) {
        return this.add(Token.token(nm), Token.token(val));
    }

    public FElem add(byte[] nm, String val) {
        return this.add(nm, Token.token(val));
    }

    public FElem add(String nm, byte[] val) {
        return this.add(Token.token(nm), val);
    }

    public FElem add(byte[] nm, byte[] val) {
        return this.add(new FAttr(nm, val));
    }

    public FElem add(QNm nm, String val) {
        return this.add(nm, Token.token(val));
    }

    public FElem add(QNm nm, byte[] val) {
        return this.add(new FAttr(nm, val));
    }

    public FElem add(String text) {
        return this.add(Token.token(text));
    }

    public FElem add(byte[] text) {
        if (text.length != 0) {
            FTxt txt = new FTxt(text);
            if (this.children == null) {
                this.children = new ANodeList(new ANode[]{txt});
            } else {
                this.children.add(txt);
            }
            txt.parent(this);
        }
        return this;
    }

    @Override
    public Atts namespaces() {
        if (this.ns == null) {
            this.ns = new Atts();
        }
        return this.ns;
    }

    @Override
    public byte[] string() {
        return this.children == null ? Token.EMPTY : this.string(this.children);
    }

    @Override
    public byte[] baseURI() {
        byte[] base = this.attribute(QNm.XML_BASE);
        return base != null ? base : Token.EMPTY;
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public BasicNodeIter attributes() {
        return this.atts != null ? FElem.iter(this.atts) : super.attributes();
    }

    @Override
    public BasicNodeIter children() {
        return this.children != null ? FElem.iter(this.children) : super.children();
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public FNode deepCopy(MainOptions options, QueryContext qc) {
        ANodeList ch = this.children != null ? new ANodeList(this.children.size()) : null;
        ANodeList at = this.atts != null ? new ANodeList(this.atts.size()) : null;
        Atts as = this.ns != null ? new Atts() : null;
        FElem node = new FElem(this.name, as, ch, at);
        if (as != null) {
            int nl = this.ns.size();
            int n = 0;
            while (n < nl) {
                as.add(this.ns.name(n), this.ns.value(n));
                ++n;
            }
        }
        if (at != null) {
            for (ANode n : this.atts) {
                at.add(n.deepCopy(options, qc));
            }
        }
        if (ch != null) {
            for (ANode n : this.children) {
                ch.add(n.deepCopy(options, qc));
            }
        }
        node.parent(this.parent);
        return node.optimize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FElem)) {
            return false;
        }
        FElem f = (FElem)obj;
        return Objects.equals(this.children, f.children) && Objects.equals(this.atts, f.atts) && Objects.equals(this.ns, f.ns) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FElem.addPlan(plan, this.planElem("name", this.name.string(), "type", this.seqType()), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder().add(60).add(this.name.string());
        if (this.ns != null) {
            int nl = this.ns.size();
            int n = 0;
            while (n < nl) {
                tb.add(32).addExt(new FNSpace(this.ns.name(n), this.ns.value(n)), new Object[0]);
                ++n;
            }
        }
        if (this.atts != null) {
            for (ANode att : this.atts) {
                tb.add(32).addExt(att, new Object[0]);
            }
        }
        if (this.hasChildren()) {
            tb.add(62);
            ANode child = (ANode)this.children.get(0);
            if (child.type == NodeType.TXT && this.children.size() == 1) {
                tb.add(FElem.toString(child.value, false, true));
            } else {
                tb.add("...");
            }
            tb.add("</").add(this.name.string()).add(62);
        } else {
            tb.add("/>");
        }
        return tb.toString();
    }
}

