/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.basex.util.Util;

public final class Reflect {
    private static final HashMap<String, Constructor<?>> CONSTRUCTORS = new HashMap();
    private static final HashMap<String, Class<?>> CLASSES = new HashMap();
    private static final HashMap<String, Field> FIELDS = new HashMap();

    private Reflect() {
    }

    public static boolean available(String pattern, Object ... ext) {
        try {
            Reflect.forName(Util.info(pattern, ext));
            return true;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return false;
        }
    }

    public static Class<?> find(String name) {
        try {
            return Reflect.forName(name);
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> c = CLASSES.get(name);
        if (c == null) {
            c = Class.forName(name);
            if (!Modifier.isPublic(c.getModifiers())) {
                throw new ClassNotFoundException(name);
            }
            CLASSES.put(name, c);
        }
        return c;
    }

    public static Field field(Class<?> clazz, String name) {
        String key = String.valueOf(clazz.getName()) + name;
        Field f = FIELDS.get(key);
        if (f == null) {
            try {
                f = clazz.getField(name);
                FIELDS.put(key, f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return f;
    }

    public static Class<?> find(String pattern, Object ... ext) {
        return Reflect.find(Util.info(pattern, ext));
    }

    public static Class<?> find(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            Class<?> c = Reflect.find(n3);
            if (c != null) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static <O> Constructor<O> find(Class<O> clazz, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(clazz.getName());
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            sb.append(c.getName());
            ++n2;
        }
        String key = sb.toString();
        Constructor<Object> m = CONSTRUCTORS.get(key);
        if (m == null) {
            try {
                try {
                    m = clazz.getConstructor(types);
                }
                catch (Throwable ex) {
                    Util.debug(ex);
                    m = clazz.getDeclaredConstructor(types);
                    m.setAccessible(true);
                }
                CONSTRUCTORS.put(key, m);
            }
            catch (Throwable ex) {
                Util.debug(ex);
            }
        }
        return m;
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        Method m = null;
        try {
            try {
                m = clazz.getMethod(name, types);
            }
            catch (Throwable ex) {
                Util.debug(ex);
                m = clazz.getDeclaredMethod(name, types);
                m.setAccessible(true);
            }
        }
        catch (Throwable ex) {
            Util.debug(ex);
        }
        return m;
    }

    public static <O> O get(Class<O> clazz) {
        try {
            return clazz != null ? (O)clazz.newInstance() : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static <O> O get(Constructor<O> clazz, Object ... args) {
        try {
            return clazz != null ? (O)clazz.newInstance(args) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object invoke(Method method, Object object, Object ... args) {
        try {
            return method != null ? method.invoke(object, args) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }
}

