/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqParam;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class RestXqWadl {
    private final HTTPConnection conn;

    RestXqWadl(HTTPConnection conn) {
        this.conn = conn;
    }

    synchronized FElem create(HashMap<String, RestXqModule> modules) {
        FElem application = new FElem("wadl:application", "http://wadl.dev.java.net/2009/02").declareNS();
        String base = this.conn.req.getRequestURL().toString();
        FElem resources = RestXqWadl.elem("resources", application).add("base", base);
        TreeMap<String, FElem> map = new TreeMap<String, FElem>();
        for (RestXqModule mod : modules.values()) {
            for (RestXqFunction func : mod.functions()) {
                TokenList descs;
                if (func.path == null) continue;
                TokenObjMap xqdoc = func.function.doc();
                String path = func.path.toString();
                String methods = func.methods.toString().replaceAll("[^A-Z ]", "");
                FElem resource = new FElem("wadl:resource", "http://wadl.dev.java.net/2009/02").add("path", path);
                map.put(String.valueOf(path) + '?' + methods, resource);
                Matcher var = Pattern.compile("\\$[^}]*").matcher(path);
                while (var.find()) {
                    RestXqWadl.addParam(var.group().substring(1), "template", resource, (TokenObjMap<TokenList>)xqdoc, func);
                }
                FElem method = RestXqWadl.elem("method", resource).add("name", methods);
                TokenList tokenList = descs = xqdoc != null ? (TokenList)xqdoc.get(Inspect.DOC_DESCRIPTION) : null;
                if (descs != null) {
                    for (byte[] desc : descs) {
                        RestXqWadl.addDoc(desc, method);
                    }
                }
                FElem request = RestXqWadl.elem("request", method);
                for (RestXqParam rxp : func.queryParams) {
                    RestXqWadl.addParam(rxp.name, "query", request, (TokenObjMap<TokenList>)xqdoc, func);
                }
                for (RestXqParam rxp : func.formParams) {
                    RestXqWadl.addParam(rxp.name, "query", request, (TokenObjMap<TokenList>)xqdoc, func);
                }
                for (RestXqParam rxp : func.headerParams) {
                    RestXqWadl.addParam(rxp.name, "header", request, (TokenObjMap<TokenList>)xqdoc, func);
                }
                FElem response = RestXqWadl.elem("response", method);
                FElem representation = RestXqWadl.elem("representation", response);
                representation.add("mediaType", HTTPConnection.mediaType(func.output).toString());
            }
        }
        for (FElem elem : map.values()) {
            resources.add((ANode)elem);
        }
        return application;
    }

    private static void addParam(String name, String style, FElem root, TokenObjMap<TokenList> xqdoc, RestXqFunction func) {
        FElem param = RestXqWadl.elem("param", root);
        param.add("name", name).add("style", style);
        QNm qn = new QNm(name);
        Var[] varArray = func.function.params;
        int n = func.function.params.length;
        int n2 = 0;
        while (n2 < n) {
            Var var = varArray[n2];
            if (var.name.eq(qn) && var.declType != null) {
                param.add("type", var.declType.toString());
            }
            ++n2;
        }
        RestXqWadl.addDoc(Inspect.doc(xqdoc, (byte[])Token.token((String)name)), param);
    }

    private static FElem elem(String name, FElem parent) {
        FElem elem = new FElem("wadl:" + name, "http://wadl.dev.java.net/2009/02");
        if (parent != null) {
            parent.add((ANode)elem);
        }
        return elem;
    }

    private static void addDoc(byte[] xqdoc, FElem parent) {
        if (xqdoc == null) {
            return;
        }
        FElem doc = RestXqWadl.elem("doc", parent);
        doc.namespaces().add(Token.EMPTY, Token.token((String)"http://www.w3.org/1999/xhtml"));
        Inspect.add((byte[])xqdoc, (FElem)doc);
    }
}

