/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.in.TextInput;
import org.basex.util.Util;

final class WebDAVUtils {
    static final char SEP = '/';
    static final String DUMMY = ".empty";

    private WebDAVUtils() {
    }

    static String stripLeadingSlash(String s) {
        return s == null || s.isEmpty() || s.charAt(0) != '/' ? s : s.substring(1);
    }

    static String name(String path) {
        return IO.get((String)path).name();
    }

    static String dbName(String db) {
        return IO.get((String)db).dbName();
    }

    static String decode(String url) {
        if (url.indexOf(37) != -1) {
            try {
                String ud = URLDecoder.decode(url, "UTF-8");
                return ud.contains("\ufffd") ? URLDecoder.decode(url, "ISO-8859-1") : ud;
            }
            catch (Exception ex) {
                Util.errln((Object)ex, (Object[])new Object[0]);
            }
        }
        return url;
    }

    static int peek(BufferInput bi) throws IOException {
        TextInput ti = new TextInput((InputStream)bi);
        int c = ti.read();
        try {
            bi.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return c;
    }
}

