/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import javax.swing.Box;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogIndex;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.Language;

final class DialogFT
extends DialogIndex {
    private static final int F_LANG = 0;
    private static final int F_STEM = 1;
    private static final int F_CASE = 2;
    private static final int F_DIA = 3;
    private static final int F_STOP = 4;
    private static final int FLAGS = 5;
    private final BaseXCheckBox[] check = new BaseXCheckBox[5];
    private final BaseXCombo language;
    private final BaseXTextField swpath;
    private final BaseXTextField ftinc;
    private final BaseXButton swbrowse;

    DialogFT(BaseXDialog dialog, boolean create) {
        super(dialog);
        this.layout(new TableLayout(create ? 10 : 16, 1, 0, 0));
        MainOptions opts = dialog.gui.context.options;
        this.add(new BaseXLabel(Text.H_FULLTEXT_INDEX, true, false).border(0, 0, 6, 0));
        this.ftinc = new BaseXTextField(dialog, opts.get(MainOptions.FTINCLUDE)).hint("name, *:name, Q{uri}*, Q{uri}name, *");
        this.add(this.ftinc);
        String sw = opts.get(MainOptions.STOPWORDS);
        String[] cb = new String[]{Text.LANGUAGE, Text.STEMMING, Text.CASE_SENSITIVE, Text.DIACRITICS, Text.STOPWORD_LIST};
        String[] desc = new String[]{Text.H_LANGUAGE, Text.H_STEMMING, Text.H_CASE, Text.H_DIACRITICS, Text.H_STOPWORDS};
        boolean[] val = new boolean[]{!opts.get(MainOptions.LANGUAGE).isEmpty(), opts.get(MainOptions.STEMMING), opts.get(MainOptions.CASESENS), opts.get(MainOptions.DIACRITICS), !sw.isEmpty()};
        BaseXLabel[] labels = new BaseXLabel[5];
        int cl = this.check.length;
        for (int c = 0; c < cl; ++c) {
            this.check[c] = new BaseXCheckBox(dialog, cb[c], val[c]);
            if (create) {
                this.check[c].setToolTipText(desc[c]);
                continue;
            }
            this.check[c].bold();
            labels[c] = new BaseXLabel(desc[c], true, false);
        }
        BaseXBack b1 = new BaseXBack(new TableLayout(1, 2, 8, 0)).border(12, 0, 0, 0);
        b1.add(this.check[0]);
        String[] langs = (String[])FTLexer.languages().finish();
        this.language = new BaseXCombo((BaseXWindow)dialog, langs);
        Language ln = Language.get(opts);
        for (String l : langs) {
            String s = l.replaceFirst(" \\(.*", "");
            if (!s.equals(ln.toString())) continue;
            this.language.setSelectedItem(l);
        }
        b1.add(this.language);
        this.add(b1);
        if (!create) {
            this.add(labels[0]);
        }
        for (int f = 1; f < 4; ++f) {
            this.add(this.check[f]);
            if (create) continue;
            this.add(labels[f]);
        }
        this.add(this.check[4]);
        this.add(Box.createVerticalStrut(4));
        BaseXBack b3 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.swpath = new BaseXTextField(dialog, sw.isEmpty() ? dialog.gui.gopts.get(GUIOptions.DATAPATH) : sw);
        b3.add(this.swpath);
        this.swbrowse = new BaseXButton(dialog, Text.BROWSE_D);
        this.swbrowse.addActionListener(e -> this.chooseStop());
        b3.add(this.swbrowse);
        this.add(b3);
        if (!create) {
            this.add(labels[4]);
        }
    }

    private void chooseStop() {
        GUIOptions gopts = this.dialog.gui.gopts;
        BaseXFileChooser fc = new BaseXFileChooser(this.dialog, Text.FILE_OR_DIR, gopts.get(GUIOptions.DATAPATH));
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file != null) {
            this.swpath.setText(file.path());
            gopts.set(GUIOptions.DATAPATH, file.path());
        }
    }

    @Override
    void action(boolean enabled) {
        boolean exists;
        for (BaseXCheckBox c : this.check) {
            c.setEnabled(enabled);
        }
        this.ftinc.setEnabled(enabled);
        this.language.setEnabled(enabled && this.check[0].isSelected());
        this.swbrowse.setEnabled(enabled && this.check[4].isSelected());
        this.swpath.setEnabled(enabled && this.check[4].isSelected());
        String sw = this.swpath.getText().trim();
        IO file = IO.get(sw);
        boolean bl = exists = !sw.isEmpty() && file.exists();
        if (exists) {
            this.dialog.gui.gopts.set(GUIOptions.DATAPATH, sw);
        }
    }

    @Override
    void setOptions() {
        GUI gui = this.dialog.gui;
        gui.set(MainOptions.LANGUAGE, this.check[0].isSelected() ? Language.get(this.language.getSelectedItem().replaceFirst(" \\(.*", "")).code() : "");
        gui.set(MainOptions.STEMMING, this.check[1].isSelected());
        gui.set(MainOptions.CASESENS, this.check[2].isSelected());
        gui.set(MainOptions.DIACRITICS, this.check[3].isSelected());
        gui.set(MainOptions.STOPWORDS, this.check[4].isSelected() ? this.swpath.getText() : "");
        gui.set(MainOptions.FTINCLUDE, this.ftinc.getText());
    }
}

