/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;

public class BaseXLabel
extends JLabel {
    public BaseXLabel() {
        this("", false, false);
    }

    public BaseXLabel(String text) {
        this(text, false, false);
    }

    public BaseXLabel(String text, boolean dist, boolean bold) {
        super(text);
        Font f = this.getFont();
        if (dist) {
            this.border(0, 0, f.getSize() / 2, 0);
        }
        if (bold) {
            this.setFont(f.deriveFont(1));
        }
    }

    public final BaseXLabel border(int t, int l, int b, int r) {
        this.setBorder(BaseXLayout.border(t, l, b, r));
        return this;
    }

    public final BaseXLabel color(Color c) {
        this.setForeground(c);
        return this;
    }

    public final BaseXLabel setText(String text, GUIConstants.Msg icon) {
        this.setIcon(text == null ? null : icon.small);
        this.setText(text == null ? " " : text);
        return this;
    }

    public final BaseXLabel large() {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), 1, (int)((double)f.getSize2D() * 1.4)));
        return this;
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag != this.isEnabled()) {
            super.setEnabled(flag);
        }
    }
}

