/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BufferOutput
extends OutputStream {
    private final int bufsize;
    private final byte[] buffer;
    private final OutputStream os;
    private int pos;

    public BufferOutput(String file) throws IOException {
        this(new FileOutputStream(file), 4096);
    }

    public BufferOutput(OutputStream os) {
        this(os, 4096);
    }

    public BufferOutput(OutputStream os, int bufs) {
        this.os = os;
        this.buffer = new byte[bufs];
        this.bufsize = bufs;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == this.bufsize) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        this.os.write(this.buffer, 0, this.pos);
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
    }
}

