/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.query.NumericRange;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.expr.index.RangeAccess;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class CmpR
extends Single {
    private static final double MAX_INTEGER = 9.007199254740992E15;
    final double min;
    final double max;
    private boolean atomic;

    private CmpR(Expr expr, double min, double max, InputInfo info) {
        super(info, expr, SeqType.BLN_O);
        this.min = min;
        this.max = max;
    }

    static Expr get(CmpG cmp, CompileContext cc) throws QueryException {
        Expr cmp1 = cmp.exprs[0];
        Expr cmp2 = cmp.exprs[1];
        Type type1 = cmp1.seqType().type;
        if (cmp1.has(Flag.NDT) || (type1.isNumber() ? type1 == AtomType.DEC : !type1.isUntyped())) {
            return cmp;
        }
        if (cmp2 instanceof RangeSeq) {
            RangeSeq seq = (RangeSeq)cmp2;
            long[] range = seq.range(false);
            return CmpR.get(cmp, range[0], range[1], cc);
        }
        if (cmp2 instanceof ANum && (!(cmp2 instanceof Dec) || type1.isUntyped() || type1.instanceOf(AtomType.ITR))) {
            double d = ((ANum)cmp2).dbl();
            return CmpR.get(cmp, d, d, cc);
        }
        return cmp;
    }

    private static Expr get(CmpG cmp, double min, double max, CompileContext cc) throws QueryException {
        Expr cmp1 = cmp.exprs[0];
        if (!cmp1.seqType().type.isNumberOrUntyped() || min < -9.007199254740992E15 || min > 9.007199254740992E15 || max < -9.007199254740992E15 || max > 9.007199254740992E15) {
            return cmp;
        }
        Expr expr = null;
        InputInfo ii = cmp.info;
        switch (cmp.op) {
            case EQ: {
                expr = new CmpR(cmp1, min, max, ii);
                break;
            }
            case GE: {
                expr = new CmpR(cmp1, min, Double.POSITIVE_INFINITY, ii);
                break;
            }
            case GT: {
                expr = new CmpR(cmp1, Math.nextUp(min), Double.POSITIVE_INFINITY, ii);
                break;
            }
            case LE: {
                expr = new CmpR(cmp1, Double.NEGATIVE_INFINITY, max, ii);
                break;
            }
            case LT: {
                expr = new CmpR(cmp1, Double.NEGATIVE_INFINITY, Math.nextDown(max), ii);
                break;
            }
        }
        return expr != null ? expr.optimize(cc) : cmp;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        SeqType st = this.expr.seqType();
        this.atomic = st.zeroOrOne() && !st.mayBeArray();
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.atomic) {
            Item item2 = this.expr.item(qc, this.info);
            return Bln.get(item2 != null && this.inRange(item2.dbl(this.info)));
        }
        if (this.expr instanceof Range || this.expr instanceof RangeSeq) {
            Value value = this.expr.value(qc);
            if (value.isEmpty()) {
                return Bln.FALSE;
            }
            if (value instanceof Item) {
                return Bln.get(this.inRange(((Item)value).dbl(this.info)));
            }
            long[] range = ((RangeSeq)value).range(false);
            return Bln.get((double)range[1] >= this.min && (double)range[0] <= this.max);
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.inRange(item.dbl(this.info))) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    private boolean inRange(double value) {
        return value >= this.min && value <= this.max;
    }

    Expr intersect(CmpR c) {
        double mx;
        if (!c.expr.equals(this.expr)) {
            return null;
        }
        double mn = Math.max(this.min, c.min);
        if (mn > (mx = Math.min(this.max, c.max))) {
            return Bln.FALSE;
        }
        return new CmpR(c.expr, mn, mx, this.info);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) {
        int mxl;
        Data data = ii.db.data();
        if (data == null ? !ii.enforce() : data.inMemory()) {
            return false;
        }
        IndexType type = ii.type(this.expr, null);
        if (type == null) {
            return false;
        }
        Stats key = this.key(ii, type);
        if (key == null) {
            return false;
        }
        NumericRange nr = new NumericRange(type, Math.max(this.min, key.min), Math.min(this.max, key.max));
        if (nr.min > nr.max || nr.max < key.min || nr.min > key.max) {
            ii.costs = IndexCosts.get(0);
            return true;
        }
        ii.costs = ii.costs(data, nr);
        if (ii.costs == null) {
            return false;
        }
        int mnl = this.min >= 0.0 && (double)((long)this.min) == this.min ? Token.token(this.min).length : -1;
        int n = mxl = this.max >= 0.0 && (double)((long)this.max) == this.max ? Token.token(this.max).length : -1;
        if (mnl != mxl || mnl == -1) {
            return false;
        }
        if (this.min == Double.NEGATIVE_INFINITY && this.max == Double.POSITIVE_INFINITY || Token.token((int)nr.min).length != Token.token((int)nr.max).length) {
            return false;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(91).addExt(this.min, new Object[0]).add(44).addExt(this.max, new Object[0]).add(93);
        ii.create(new RangeAccess(this.info, nr, ii.db), true, this.info, Util.info("apply % index for %", "range", tb));
        return true;
    }

    private Stats key(IndexInfo ii, IndexType type) {
        Data data = ii.db.data();
        if (!(data != null && data.meta.uptodate && data.nspaces.isEmpty() && this.expr instanceof AxisPath)) {
            return null;
        }
        NameTest test = ii.test;
        if (test == null) {
            Step step;
            AxisPath path = (AxisPath)this.expr;
            int st = path.steps.length - 1;
            if (type == IndexType.TEXT) {
                Step step2 = step = st == 0 ? ii.step : path.step(st - 1);
                if (step.test.kind != Test.Kind.NAME) {
                    return null;
                }
            } else {
                step = path.step(st);
                if (!step.simple(Axis.ATTR, true)) {
                    return null;
                }
            }
            test = (NameTest)step.test;
        }
        Names names = type == IndexType.TEXT ? data.elemNames : data.attrNames;
        Stats stats = names.stats(names.id(test.name.local()));
        return stats == null || StatsType.isNumeric(stats.type) ? stats : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpR cmp = new CmpR(this.expr.copy(cc, vm), this.min, this.max, this.info);
        cmp.atomic = this.atomic;
        return cmp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpR)) {
            return false;
        }
        CmpR c = (CmpR)obj;
        return this.min == c.min && this.max == c.max && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        CmpR.addPlan(plan, this.planElem("min", this.min, "max", this.max), this.expr);
    }

    @Override
    public String description() {
        return "range comparison";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        if (this.min == this.max) {
            sb.append(this.expr).append(" = ").append(this.min);
        } else {
            if (this.min != Double.NEGATIVE_INFINITY) {
                sb.append(this.min).append(" <= ");
            }
            sb.append(this.expr);
            if (this.max != Double.POSITIVE_INFINITY) {
                sb.append(" <= ").append(this.max);
            }
        }
        return sb.append(")").toString();
    }
}

