/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class FTExpr
extends ParseExpr {
    public final FTExpr[] exprs;

    FTExpr(InputInfo info, FTExpr ... exprs) {
        super(info, SeqType.BLN_O);
        this.exprs = exprs;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        int es = this.exprs.length;
        for (int e = 0; e < es; ++e) {
            this.exprs[e] = this.exprs[e].compile(cc);
        }
        return this;
    }

    @Override
    public FTExpr optimize(CompileContext cc) {
        return this;
    }

    @Override
    public abstract FTNode item(QueryContext var1, InputInfo var2) throws QueryException;

    @Override
    public abstract FTIter iter(QueryContext var1) throws QueryException;

    @Override
    public boolean has(Flag ... flags) {
        for (FTExpr expr : this.exprs) {
            if (!expr.has(flags)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removable(Var var) {
        for (FTExpr expr : this.exprs) {
            if (((Expr)expr).removable(var)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.exprs);
    }

    @Override
    public FTExpr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        return FTExpr.inlineAll(this.exprs, var, ex, cc) ? this.optimize(cc) : null;
    }

    @Override
    public abstract FTExpr copy(CompileContext var1, IntObjMap<Var> var2);

    public boolean usesExclude() {
        for (FTExpr expr : this.exprs) {
            if (!expr.usesExclude()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return FTExpr.visitAll(visitor, this.exprs);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (FTExpr expr : this.exprs) {
            size += ((Expr)expr).exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FTExpr && Array.equals(this.exprs, ((FTExpr)obj).exprs);
    }

    @Override
    public void plan(FElem plan) {
        FTExpr.addPlan(plan, this.planElem(new Object[0]), this.exprs);
    }

    final String toString(Object sep) {
        StringBuilder sb = new StringBuilder();
        int es = this.exprs.length;
        for (int e = 0; e < es; ++e) {
            sb.append(e == 0 ? "" : sep.toString()).append(this.exprs[e]);
        }
        return sb.toString();
    }
}

