/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationOptions;
import org.basex.query.util.collation.UCACollation;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class UCAOptions
extends CollationOptions {
    public static final EnumOption<Options.YesNo> FALLBACK = new EnumOption<Options.YesNo>("fallback", Options.YesNo.YES);
    public static final StringOption LANG = new StringOption("lang");
    public static final StringOption VERSION = new StringOption("version");
    public static final StringOption STRENGTH = new StringOption("strength");
    public static final StringOption ALTERNATE = new StringOption("alternate");
    public static final StringOption BACKWARDS = new StringOption("backwards");
    public static final StringOption NORMALIZATION = new StringOption("normalization");
    public static final StringOption CASELEVEL = new StringOption("caseLevel");
    public static final StringOption CASEFIRST = new StringOption("caseFirst");
    public static final StringOption NUMERIC = new StringOption("numeric");
    public static final StringOption REORDER = new StringOption("reorder");
    static final Class<?> COLLATOR = Reflect.find("com.ibm.icu.text.Collator");
    static final boolean ACTIVE = COLLATOR != null;
    static final Class<?> RBC = Reflect.find("com.ibm.icu.text.RuleBasedCollator");

    @Override
    Collation get(HashMap<String, String> args) throws BaseXException {
        String v;
        this.assign(args);
        Locale locale = Locale.US;
        if (this.contains(LANG) && (locale = CollationOptions.Locales.MAP.get(this.get(LANG))) == null) {
            throw this.error(LANG);
        }
        Method m = Reflect.method(COLLATOR, "getInstance", Locale.class);
        Object coll = Reflect.invoke(m, null, locale);
        if (!coll.getClass().equals(RBC)) {
            throw new BaseXException("Invalid collator: %.", coll.getClass().getName());
        }
        if (this.contains(VERSION)) {
            v = this.get(VERSION);
            try {
                Class<?> vc = Reflect.find("com.ibm.icu.util.VersionInfo");
                Object vi = Reflect.invoke(Reflect.method(vc, "getInstance", String.class), null, v);
                Object vic = Reflect.invoke(Reflect.method(RBC, "getUCAVersion", new Class[0]), coll, new Object[0]);
                if (vi == null || vic == null || ((Comparable)vi).compareTo(vic) > 0) {
                    throw this.error(VERSION);
                }
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                throw new BaseXException("Version not supported: %.", v);
            }
        }
        if (this.contains(STRENGTH)) {
            Integer s;
            v = this.get(STRENGTH);
            if (Strings.eq(v, "primary", "1")) {
                s = 0;
            } else if (Strings.eq(v, "secondary", "2")) {
                s = 1;
            } else if (Strings.eq(v, "tertiary", "3")) {
                s = 2;
            } else if (Strings.eq(v, "quaternary", "4")) {
                s = 3;
            } else if (Strings.eq(v, "identical", "5")) {
                s = 15;
            } else {
                throw this.error(STRENGTH);
            }
            Reflect.invoke(Reflect.method(RBC, "setStrength", Integer.TYPE), coll, s);
        }
        if (this.contains(ALTERNATE)) {
            boolean b;
            v = this.get(ALTERNATE);
            if (Strings.eq(v, "non-ignorable")) {
                b = false;
            } else if (Strings.eq(v, "shifted", "blanked")) {
                b = true;
            } else {
                throw this.error(ALTERNATE);
            }
            Reflect.invoke(Reflect.method(RBC, "setAlternateHandlingShifted", Boolean.TYPE), coll, b);
        }
        if (this.contains(BACKWARDS)) {
            Reflect.invoke(Reflect.method(RBC, "setFrenchCollation", Boolean.TYPE), coll, this.yesNo(BACKWARDS));
        }
        if (this.contains(NORMALIZATION)) {
            Reflect.invoke(Reflect.method(RBC, "setDecomposition", Integer.TYPE), coll, this.yesNo(NORMALIZATION) ? 17 : 16);
        }
        if (this.contains(CASELEVEL)) {
            Reflect.invoke(Reflect.method(RBC, "setCaseLevel", Boolean.TYPE), coll, this.yesNo(CASELEVEL));
        }
        if (this.contains(CASEFIRST)) {
            String f;
            v = this.get(CASEFIRST);
            switch (v) {
                case "upper": {
                    f = "setUpperCaseFirst";
                    break;
                }
                case "lower": {
                    f = "setLowerCaseFirst";
                    break;
                }
                default: {
                    throw this.error(CASEFIRST);
                }
            }
            Reflect.invoke(Reflect.method(RBC, f, Boolean.TYPE), coll, true);
        }
        if (this.contains(NUMERIC)) {
            Reflect.invoke(Reflect.method(RBC, "setNumericCollation", Boolean.TYPE), coll, this.yesNo(NUMERIC));
        }
        if (this.contains(REORDER)) {
            v = this.get(REORDER);
            IntList list = new IntList();
            Method uscript = Reflect.method(Reflect.find("com.ibm.icu.lang.UScript"), "getCode", String.class);
            String[] stringArray = Strings.split(v, ',');
            int n = stringArray.length;
            block24: for (int i = 0; i < n; ++i) {
                String code;
                switch (code = stringArray[i]) {
                    case "space": {
                        list.add(4096);
                        continue block24;
                    }
                    case "punct": {
                        list.add(4097);
                        continue block24;
                    }
                    case "symbol": {
                        list.add(4098);
                        continue block24;
                    }
                    case "currency": {
                        list.add(4099);
                        continue block24;
                    }
                    case "digit": {
                        list.add(4100);
                        continue block24;
                    }
                    default: {
                        int[] c;
                        int[] nArray = c = code.length() == 4 ? (int[])Reflect.invoke(uscript, null, code) : null;
                        if (c != null) {
                            list.add((int)c[0]);
                            continue block24;
                        }
                        throw this.error(REORDER);
                    }
                }
            }
            if (!list.isEmpty()) {
                Reflect.invoke(Reflect.method(RBC, "setReorderCodes", int[].class), coll, new Object[]{list.finish()});
            }
        }
        return new UCACollation((Comparator)coll);
    }

    private boolean yesNo(StringOption option) throws BaseXException {
        String v = this.get(option);
        if (v.equals("yes")) {
            return true;
        }
        if (v.equals("no")) {
            return false;
        }
        throw this.error(option);
    }
}

