/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.net.URI;
import java.net.URISyntaxException;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.UriParser;
import org.basex.query.value.item.AStr;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Uri
extends AStr {
    public static final Uri EMPTY = new Uri(Token.EMPTY);
    private UriParser.ParsedUri pUri;

    private Uri(byte[] value) {
        super(AtomType.URI, value);
    }

    public static Uri uri(byte[] value) {
        return Uri.uri(value, true);
    }

    public static Uri uri(String value) {
        return Uri.uri(Token.token(value), true);
    }

    public static Uri uri(byte[] value, boolean normalize) {
        byte[] u = normalize ? Token.normalize(value) : value;
        return u.length == 0 ? EMPTY : new Uri(u);
    }

    public boolean eq(Uri uri) {
        return Token.eq(this.string(), uri.string());
    }

    public Uri resolve(Uri add, InputInfo info) throws QueryException {
        if (add.value.length == 0) {
            return this;
        }
        try {
            URI base = new URI(Token.string(this.value));
            URI res = new URI(Token.string(add.value));
            String uri = base.resolve(res).toString();
            if (uri.startsWith("file:/")) {
                uri = uri.replaceAll("^file:/([^/])", "file:///$1");
            }
            return Uri.uri(Token.token(uri), false);
        }
        catch (URISyntaxException ex) {
            throw QueryError.URIARG_X.get(info, ex.getMessage());
        }
    }

    public boolean isAbsolute() {
        return this.isValid() && this.parsed().scheme() != null;
    }

    public boolean isValid() {
        return this.parsed().valid();
    }

    @Override
    public byte[] string(InputInfo info) {
        return this.value;
    }

    public byte[] string() {
        return this.value;
    }

    private UriParser.ParsedUri parsed() {
        if (this.pUri == null) {
            this.pUri = UriParser.parse(Token.string(Token.encodeUri(this.value, true)));
        }
        return this.pUri;
    }

    @Override
    public URI toJava() throws QueryException {
        try {
            return new URI(Token.string(this.value));
        }
        catch (URISyntaxException ex) {
            throw new QueryException(ex);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Uri)) {
            return false;
        }
        Uri u = (Uri)obj;
        return this.type == u.type && Token.eq(this.value, u.value);
    }

    @Override
    public String toString() {
        return Uri.toString(this.value);
    }
}

