/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.EnumMap;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class FuncType
implements Type {
    public final AnnList anns;
    public final SeqType declType;
    public final SeqType[] argTypes;
    private EnumMap<Occ, SeqType> seqTypes;

    FuncType(SeqType declType, SeqType ... argTypes) {
        this(new AnnList(), declType, argTypes);
    }

    FuncType(AnnList anns, SeqType declType, SeqType ... argTypes) {
        this.anns = anns;
        this.declType = declType == null ? SeqType.ITEM_ZM : declType;
        this.argTypes = argTypes;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public final boolean isSortable() {
        return false;
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public byte[] string() {
        return Token.token("function");
    }

    @Override
    public FItem cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        if (!(item instanceof FItem)) {
            throw QueryError.typeError(item, this, info);
        }
        FItem func = (FItem)item;
        return this == SeqType.ANY_FUNC ? func : func.coerceTo(this, qc, info, false);
    }

    @Override
    public final Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
        throw Util.notExpected(value, new Object[0]);
    }

    @Override
    public final Item castString(String string, QueryContext qc, StaticContext sc, InputInfo info) {
        throw Util.notExpected(string, new Object[0]);
    }

    @Override
    public boolean eq(Type type) {
        if (this == type) {
            return true;
        }
        if (type.getClass() != FuncType.class) {
            return false;
        }
        FuncType ft = (FuncType)type;
        if (this == SeqType.ANY_FUNC || ft == SeqType.ANY_FUNC || this.argTypes.length != ft.argTypes.length) {
            return false;
        }
        int al = this.argTypes.length;
        for (int a = 0; a < al; ++a) {
            if (this.argTypes[a].eq(ft.argTypes[a])) continue;
            return false;
        }
        return this.declType.eq(ft.declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type == AtomType.ITEM || type == SeqType.ANY_FUNC) {
            return true;
        }
        if (!(type instanceof FuncType) || type instanceof MapType || type instanceof ArrayType || this == SeqType.ANY_FUNC) {
            return false;
        }
        FuncType ft = (FuncType)type;
        int al = this.argTypes.length;
        if (al != ft.argTypes.length || !this.declType.instanceOf(ft.declType)) {
            return false;
        }
        for (int a = 0; a < al; ++a) {
            if (ft.argTypes[a].instanceOf(this.argTypes[a])) continue;
            return false;
        }
        for (Ann ann : ft.anns) {
            if (this.anns.contains(ann)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type union(Type type) {
        if (!(type instanceof FuncType)) {
            return AtomType.ITEM;
        }
        FuncType ft = (FuncType)type;
        if (this == SeqType.ANY_FUNC || ft == SeqType.ANY_FUNC) {
            return SeqType.ANY_FUNC;
        }
        int al = this.argTypes.length;
        if (al != ft.argTypes.length) {
            return SeqType.ANY_FUNC;
        }
        SeqType[] arg = new SeqType[al];
        for (int a = 0; a < al; ++a) {
            arg[a] = this.argTypes[a].intersect(ft.argTypes[a]);
            if (arg[a] != null) continue;
            return SeqType.ANY_FUNC;
        }
        return FuncType.get(this.anns.union(ft.anns), this.declType.union(ft.declType), arg);
    }

    @Override
    public Type intersect(Type type) {
        if (type instanceof MapType || type instanceof ArrayType) {
            return type.intersect(this);
        }
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            SeqType dt = this.declType.intersect(ft.declType);
            int al = this.argTypes.length;
            if (dt != null && al == ft.argTypes.length) {
                SeqType[] arg = new SeqType[al];
                for (int a = 0; a < al; ++a) {
                    arg[a] = this.argTypes[a].union(ft.argTypes[a]);
                }
                AnnList list = this.anns.intersect(ft.anns);
                return list == null ? null : FuncType.get(list, dt, arg);
            }
        }
        return null;
    }

    public static FuncType get(AnnList anns, SeqType declType, SeqType ... args) {
        return new FuncType(anns, declType, args);
    }

    public static FuncType get(SeqType declType, SeqType ... args) {
        return FuncType.get(new AnnList(), declType, args);
    }

    public static Type find(QNm name) {
        if (name.uri().length == 0) {
            byte[] ln = name.local();
            if (Token.eq(ln, Token.token("function"))) {
                return SeqType.ANY_FUNC;
            }
            if (Token.eq(ln, Token.token("map"))) {
                return SeqType.ANY_MAP;
            }
            if (Token.eq(ln, Token.token("array"))) {
                return SeqType.ANY_ARRAY;
            }
        }
        return null;
    }

    public static FuncType get(AnnList anns, SeqType declType, Var[] params) {
        int pl = params.length;
        SeqType[] argTypes = new SeqType[pl];
        for (int p = 0; p < pl; ++p) {
            argTypes[p] = params[p] == null ? SeqType.ITEM_ZM : params[p].declaredType();
        }
        return new FuncType(anns, declType, argTypes);
    }

    @Override
    public final AtomType atomic() {
        return null;
    }

    @Override
    public final Type.ID id() {
        return Type.ID.FUN;
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.anns.toString()).add("function").add(40);
        if (this == SeqType.ANY_FUNC) {
            tb.add(42).add(41);
        } else {
            tb.addSep(this.argTypes, ", ").add(") as ").add(this.declType.toString());
        }
        return tb.toString();
    }
}

