/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import org.basex.data.DataText;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;
import org.basex.util.Token;
import org.basex.util.XMLToken;

final class SyntaxJS
extends Syntax {
    private static final HashSet<String> KEYWORDS = new HashSet();
    private int comment1;
    private int comment2;
    private int quote;
    private boolean var;
    private boolean back;

    SyntaxJS() {
    }

    @Override
    public void init(Color color) {
        super.init(color);
        this.quote = 0;
        this.var = false;
        this.back = false;
        this.comment1 = 0;
        this.comment2 = 0;
    }

    @Override
    public Color getColor(TextIterator iter) {
        int ch = iter.curr();
        if (this.quote != 0) {
            if (this.back) {
                this.back = false;
            } else if (ch == this.quote) {
                this.quote = 0;
            } else {
                this.back = ch == 92;
            }
            return GUIConstants.VALUE;
        }
        if (this.comment1 == 0 && ch == 47) {
            ++this.comment1;
        } else if (this.comment1 == 1) {
            this.comment1 = ch == 42 ? 2 : 0;
        } else if (this.comment1 == 2 && ch == 42) {
            ++this.comment1;
        } else if (this.comment1 == 3) {
            int n = this.comment1 = ch == 47 ? 0 : 2;
        }
        if (this.comment2 == 0 && ch == 47) {
            ++this.comment2;
        } else if (this.comment2 == 1) {
            this.comment2 = ch == 47 ? 2 : 0;
        } else if (this.comment2 == 2 && ch == 10) {
            this.comment2 = 0;
        }
        if (this.comment1 != 0 || this.comment2 != 0) {
            this.var = false;
            return GUIConstants.COMMENT;
        }
        if (this.back) {
            this.back = false;
        } else if (ch == 92) {
            this.back = true;
        } else if (ch == 34 || ch == 39) {
            this.quote = ch;
            return GUIConstants.VALUE;
        }
        if (ch == 36) {
            this.var = true;
            return GUIConstants.VARIABLE;
        }
        if (this.var) {
            this.var = XMLToken.isNCStartChar(ch);
            return GUIConstants.VARIABLE;
        }
        if (Token.digit(ch)) {
            return GUIConstants.DIGIT;
        }
        if (!XMLToken.isNCStartChar(ch)) {
            return GUIConstants.COMMENT;
        }
        if (KEYWORDS.contains(iter.currString())) {
            return GUIConstants.KEYWORD;
        }
        return this.plain;
    }

    @Override
    public byte[] commentOpen() {
        return DataText.JSCOMM_O;
    }

    @Override
    public byte[] commentEnd() {
        return DataText.JSCOMM_C;
    }

    static {
        Collections.addAll(KEYWORDS, "await", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield");
    }
}

