/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXScrollBar;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextEditor;
import org.basex.gui.text.TextIterator;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

final class TextRenderer
extends BaseXBack {
    private final GUI gui;
    private static final int OFFSET = 5;
    private final TextEditor text;
    private final BaseXScrollBar scroll;
    private final boolean edit;
    private final IntList parentheses = new IntList();
    private Font font;
    private Font defaultFont;
    private Font boldFont;
    private int fontHeight;
    private FontMetrics fontMetrics;
    private int[] charWidths;
    private int stringWidth;
    private boolean showInvisible;
    private boolean showNL;
    private int margin;
    private int indent;
    private boolean showLines;
    private boolean markline;
    private int offset;
    private int width;
    private int height;
    private int x;
    private int y;
    private int lineY;
    private int line;
    private boolean lineC;
    final TokenBuilder stringCache = new TokenBuilder(4);
    private final int[] cursor = new int[2];
    private Syntax syntax = Syntax.SIMPLE;
    private boolean caret;
    private boolean highlighted;
    private boolean link;

    TextRenderer(TextEditor text, BaseXScrollBar scroll, boolean edit, GUI gui) {
        this.setOpaque(false);
        this.text = text;
        this.scroll = scroll;
        this.edit = edit;
        this.gui = gui;
        this.font(GUIConstants.dmfont);
    }

    @Override
    public void setFont(Font f) {
        this.defaultFont = f;
        this.boldFont = f.deriveFont(1);
        this.font(f);
        if (this.gui != null) {
            this.margin = this.gui.gopts.get(GUIOptions.SHOWMARGIN) != false ? Math.max(this.gui.gopts.get(GUIOptions.MARGIN), 1) : -1;
            this.showInvisible = this.gui.gopts.get(GUIOptions.SHOWINVISIBLE);
            this.showNL = this.gui.gopts.get(GUIOptions.SHOWNL);
            this.showLines = this.gui.gopts.get(GUIOptions.SHOWLINES);
            this.markline = this.gui.gopts.get(GUIOptions.MARKLINE);
            this.indent = Math.max(1, this.gui.gopts.get(GUIOptions.INDENT));
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.parentheses.reset();
        TextIterator iter = this.init(g, false);
        int oldL = 0;
        while (this.more(iter, g)) {
            if (this.line != oldL && this.y >= 0) {
                this.drawLineNumber(g);
                oldL = this.line;
            }
            this.write(iter, g);
        }
        if (this.x == this.offset) {
            this.markLine(g);
        }
        if (this.line != oldL) {
            this.drawLineNumber(g);
        }
        this.stringWidth = 0;
        int s = iter.pos();
        if (this.caret && s == iter.caret()) {
            this.drawCaret(g, this.x);
        }
        if (s == iter.error()) {
            this.drawError(g);
        }
        this.drawLinesSep(g);
    }

    private void drawLineNumber(Graphics g) {
        if (this.edit && this.showLines) {
            g.setColor(GUIConstants.gray);
            String s = Integer.toString(this.line);
            g.drawString(s, this.offset - this.fontMetrics.stringWidth(s) - 10, this.y);
        }
    }

    private void drawErrorLine(Graphics g) {
        g.setColor(GUIConstants.colormark2A);
        g.fillRect(0, this.lineY, this.offset - 7, this.fontHeight);
    }

    private void drawLinesSep(Graphics g) {
        if (this.edit) {
            int lx;
            if (this.showLines) {
                lx = this.offset - 7;
                g.setColor(GUIConstants.lgray);
                g.drawLine(lx, 0, lx, this.height);
            }
            if (this.margin != -1) {
                lx = this.offset + this.charWidth(32) * this.margin;
                g.setColor(GUIConstants.lgray);
                g.drawLine(lx, 0, lx, this.height);
            }
        }
    }

    void search(SearchContext sc, boolean jump) {
        this.text.search(sc, jump);
    }

    int[] replace(ReplaceContext rc) {
        return this.text.replace(rc);
    }

    int[] cursor() {
        return this.cursor;
    }

    int jump(SearchBar.SearchDir dir, boolean select) {
        int pos = this.text.jump(dir, select);
        if (pos == -1) {
            return -1;
        }
        int hh = this.height;
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g) && iter.pos() < pos) {
            this.next(iter);
        }
        this.height = hh;
        return this.y;
    }

    int[] pos() {
        int hh = this.height;
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        boolean more = true;
        int col = 1;
        while (this.more(iter, g)) {
            int p = iter.pos();
            while (iter.more()) {
                boolean bl = more = iter.pos() < iter.caret();
                if (!more) break;
                iter.next();
                ++col;
            }
            if (!more) break;
            iter.pos(p);
            if (!this.next(iter)) continue;
            col = 1;
        }
        this.height = hh;
        return new int[]{this.line, col};
    }

    private void font(Font f) {
        this.font = f;
        this.fontHeight = f.getSize() * 5 / 4;
        this.fontMetrics = this.getFontMetrics(f);
        this.charWidths = this.fontMetrics.getWidths();
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        this.width = Integer.MAX_VALUE;
        this.height = Integer.MAX_VALUE;
        TextIterator iter = this.init(g, true);
        int maxX = 0;
        while (this.more(iter, g)) {
            if (iter.curr() == 10) {
                maxX = Math.max(this.x, maxX);
            }
            this.next(iter);
        }
        return new Dimension(Math.max(this.x, maxX) + this.charWidths[32], this.y + this.fontHeight);
    }

    private TextIterator init(Graphics g, boolean start) {
        this.syntax.init(GUIConstants.TEXT);
        this.font = this.defaultFont;
        this.font(this.font);
        this.offset = 5;
        if (g != null) {
            g.setFont(this.font);
            if (this.edit && this.showLines) {
                this.offset += this.fontMetrics.stringWidth(Integer.toString(this.text.lines())) + 10;
            }
        }
        this.x = this.offset;
        this.y = this.fontHeight - (start ? 0 : this.scroll.pos()) - 2;
        this.lineY = this.y - (this.fontHeight << 2) / 5;
        this.line = 1;
        this.link = false;
        TextIterator iter = new TextIterator(this.text);
        this.lineC = this.edit && iter.caretLine(true);
        return iter;
    }

    void updateScrollbar() {
        this.width = this.getWidth() - (this.offset >> 1);
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g)) {
            this.next(iter);
        }
        this.height = this.getHeight() + this.fontHeight;
        this.scroll.height(this.y + 5);
    }

    int cursorY() {
        int hh = this.height;
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g) && !iter.edited()) {
            this.next(iter);
        }
        this.height = hh;
        return this.y - this.fontHeight;
    }

    private boolean more(TextIterator iter, Graphics g) {
        int w = this.width;
        if (g == null || !iter.moreStrings(w)) {
            return false;
        }
        int p = iter.pos();
        int m = w - this.offset;
        int sw = 0;
        while (iter.more()) {
            int ch = iter.next();
            if (ch == 63742) {
                this.font(this.boldFont);
                continue;
            }
            if (ch == 63741) {
                this.font(this.defaultFont);
                continue;
            }
            if (ch == 63739) {
                this.link ^= true;
                continue;
            }
            if ((sw += this.charWidth(ch)) <= w - this.x) continue;
            if (sw > m) {
                iter.posEnd(iter.pos());
                break;
            }
            this.newline(this.fontHeight);
        }
        iter.pos(p);
        this.stringWidth = sw;
        return this.y < this.height;
    }

    private void newline(int h) {
        this.x = this.offset;
        this.y += h;
        this.lineY += h;
    }

    private void markLine(Graphics g) {
        if (this.lineC && this.markline) {
            g.setColor(GUIConstants.color3A);
            g.fillRect(0, this.lineY, this.width + this.offset, this.fontHeight);
        }
    }

    private boolean next(TextIterator iter) {
        int ch = iter.curr();
        if (ch == 10 || ch == 63743) {
            this.newline(this.fontHeight >> (ch == 10 ? 0 : 1));
            ++this.line;
            this.lineC = this.edit && iter.caretLine(false);
            return true;
        }
        this.x += this.stringWidth;
        return false;
    }

    private void write(TextIterator iter, Graphics g) {
        int yy;
        if (this.x == this.offset) {
            this.markLine(g);
        }
        Color color = this.isEnabled() ? (this.highlighted ? GUIConstants.GREEN : (this.link ? GUIConstants.color4 : this.syntax.getColor(iter))) : GUIConstants.gray;
        int cp = iter.curr();
        this.highlighted = cp == 63740;
        int pos = iter.pos();
        int cpos = iter.caret();
        if (this.y > 0 && this.y < this.height) {
            int cw;
            int xx;
            if (iter.selectStart()) {
                xx = this.x;
                while (!iter.inSelect() && iter.more()) {
                    xx += this.charWidth(iter.next());
                }
                cw = 0;
                while (iter.inSelect() && iter.more()) {
                    cw += this.charWidth(iter.next());
                }
                g.setColor(GUIConstants.color2A);
                g.fillRect(xx, this.lineY, cw, this.fontHeight);
                iter.pos(pos);
            }
            xx = this.x;
            while (iter.more() && iter.searchStart()) {
                while (!iter.inSearch() && iter.more()) {
                    xx += this.charWidth(iter.next());
                }
                cw = 0;
                while (iter.inSearch() && iter.more()) {
                    cw += this.charWidth(iter.next());
                }
                g.setColor(GUIConstants.color2A);
                g.fillRect(xx, this.lineY, cw, this.fontHeight);
                xx += cw;
            }
            iter.pos(pos);
            if (iter.erroneous()) {
                this.drawError(g);
            }
            if (this.showNL && cp == 10) {
                g.setColor(GUIConstants.gray);
                g.drawString("\u00b6", this.x, this.y);
            } else if (this.showInvisible && cp == 9) {
                int lh = 1 + this.fontHeight / 12;
                int xe = this.x + this.charWidth(9) - lh;
                yy = this.y - this.fontHeight * 3 / 10;
                int as = (lh << 1) - 1;
                g.setColor(GUIConstants.gray);
                g.drawLine(this.x + lh, yy, xe, yy);
                g.drawLine(xe - as, yy - as, xe, yy);
                g.drawLine(xe - as, yy + as, xe, yy);
            } else if (cp >= 57344 && cp <= 63743) {
                g.setFont(this.font);
            } else if (cp > 32) {
                if (this.showInvisible && Character.isSpaceChar(cp)) {
                    int s = this.fontHeight / 12 + 1;
                    g.setColor(GUIConstants.gray);
                    g.fillRect(this.x + (this.stringWidth >> 1), this.y - this.fontHeight * 3 / 10, s, s);
                } else {
                    g.setColor(color);
                    xx = this.x;
                    while (iter.more()) {
                        cp = iter.next();
                        g.drawString(this.stringCache.reset().add(cp).toString(), xx, this.y);
                        xx += this.charWidth(cp);
                    }
                    iter.pos(pos);
                }
            }
            if (this.link) {
                g.drawLine(this.x, this.y + 1, this.x + this.stringWidth, this.y + 1);
            }
            if (this.caret && iter.edited()) {
                xx = this.x;
                while (iter.more()) {
                    if (cpos == iter.pos()) {
                        this.drawCaret(g, xx);
                        break;
                    }
                    xx += this.charWidth(iter.next());
                }
                iter.pos(pos);
            }
        }
        if (cp == 40 || cp == 91 || cp == 123) {
            this.parentheses.add(this.x);
            this.parentheses.add(this.y);
            this.parentheses.add(pos);
            this.parentheses.add(cp);
        } else if (!(cp != 41 && cp != 93 && cp != 125 || this.parentheses.isEmpty())) {
            int open;
            int n = cp == 41 ? 40 : (open = cp == 93 ? 91 : 123);
            if (this.parentheses.peek() == open) {
                this.parentheses.pop();
                int cr = this.parentheses.pop();
                yy = this.parentheses.pop();
                int xx = this.parentheses.pop();
                if (cpos == pos || cpos == cr) {
                    g.setColor(GUIConstants.color4);
                    g.drawRect(xx, yy - (this.fontHeight << 2) / 5, this.charWidth(open), this.fontHeight);
                    g.drawRect(this.x, this.lineY, this.charWidth(cp), this.fontHeight);
                }
            }
        }
        this.next(iter);
    }

    private void drawCaret(Graphics g, int xx) {
        g.setColor(GUIConstants.dgray);
        g.fillRect(xx, this.lineY, 2, this.fontHeight);
        this.cursor[0] = xx;
        this.cursor[1] = this.lineY + this.fontHeight;
    }

    private void drawError(Graphics g) {
        int ww = this.stringWidth == 0 ? this.charWidth(32) : this.stringWidth;
        int s = Math.max(2, this.fontHeight / 6);
        g.setColor(GUIConstants.RED);
        for (int xp = this.x; xp < this.x + ww; xp += 2) {
            g.drawLine(xp - 1, this.y + 2, xp, this.y + s + 1);
        }
        if (this.edit) {
            this.drawErrorLine(g);
        }
    }

    private int charWidth(int cp) {
        return cp == 9 ? this.charWidths[32] * this.indent : (cp < 256 ? this.charWidths[cp] : (cp >= 57344 && cp <= 63743 || cp >= 55296 && cp <= 56320 ? 0 : this.fontMetrics.charWidth(cp)));
    }

    TextIterator jump(Point p) {
        int xx = p.x;
        int yy = p.y - this.fontHeight / 5;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, false);
        if (yy > this.y - this.fontHeight) {
            int s = iter.pos();
            while (true) {
                if (xx > this.x && yy < this.y - this.fontHeight) {
                    iter.pos(s);
                    break;
                }
                if (!this.more(iter, g)) {
                    while (iter.more()) {
                        iter.next();
                    }
                    break;
                }
                if (xx <= this.x && yy < this.y) break;
                if (xx > this.x && xx <= this.x + this.stringWidth && yy > this.y - this.fontHeight && yy <= this.y) {
                    int ww;
                    while (iter.more() && xx >= this.x + (ww = this.charWidth(iter.curr()))) {
                        this.x += ww;
                        iter.next();
                    }
                    break;
                }
                s = iter.pos();
                this.next(iter);
            }
        }
        iter.link(this.link);
        return iter;
    }

    int fontHeight() {
        return this.fontHeight;
    }

    void caret(boolean c) {
        this.caret = c;
        this.repaint();
    }

    boolean caret() {
        return this.caret;
    }

    void setSyntax(Syntax s) {
        this.syntax = s;
    }

    Syntax getSyntax() {
        return this.syntax;
    }
}

