/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Preds;
import org.basex.query.expr.SimpleFilter;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class Filter
extends Preds {
    public Expr root;

    protected Filter(InputInfo info, Expr root, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
        this.root = root;
    }

    public static Expr get(InputInfo info, Expr root, Expr ... exprs) {
        Expr expr = Filter.simplify(root, exprs);
        if (expr != null) {
            return expr;
        }
        Expr pred = exprs[0];
        if (exprs.length == 1 && pred.isSimple()) {
            return new SimpleFilter(info, root, exprs);
        }
        return new CachedFilter(info, root, exprs);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        super.checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        this.root = this.root.compile(cc);
        cc.pushFocus(this.root);
        try {
            super.compile(cc);
        }
        finally {
            cc.removeFocus();
        }
        return this.optimize(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        if (this.root.seqType().zero()) {
            return cc.replaceWith(this, this.root);
        }
        this.simplify(cc, this.root);
        cc.pushFocus(this.root);
        try {
            Expr expr = super.optimize(cc);
            if (expr != this) {
                Expr expr2 = expr;
                return expr2;
            }
        }
        finally {
            cc.removeFocus();
        }
        if (!this.exprType(this.root.seqType(), this.root.size())) {
            return cc.emptySeq(this);
        }
        Expr exp = Filter.simplify(this.root, this.exprs);
        if (exp != null) {
            return exp.optimize(cc);
        }
        if (!this.positional()) {
            if (this.root instanceof Value && this.root.data() != null && this.root.seqType().type == NodeType.DOC) {
                return Path.get(this.info, this.root, Step.get(this.info, Axis.SELF, KindTest.NOD, this.exprs)).optimize(cc);
            }
            Expr expr = this.exprs[0];
            if (this.exprs.length == 1 && expr.isSimple() && !expr.seqType().mayBeNumber()) {
                return new If(this.info, expr, this.root, (Expr)Empty.SEQ).optimize(cc);
            }
            return this.copyType(new IterFilter(this.info, this.root, this.exprs));
        }
        Expr rt = this.root;
        boolean opt = false;
        for (Expr expr : this.exprs) {
            ParseExpr pos;
            exp = null;
            if (expr.isFunction(Function.LAST)) {
                exp = rt instanceof Value ? ((Value)rt).itemAt(rt.size() - 1L) : cc.function(Function._UTIL_LAST_FROM, this.info, rt);
            } else if (expr instanceof ItrPos) {
                pos = (ItrPos)expr;
                if (rt instanceof Value) {
                    long size = pos.min - 1L;
                    long len = Math.min(pos.max, rt.size()) - size;
                    exp = len <= 0L ? Empty.SEQ : ((Value)rt).subSequence(size, len, cc.qc);
                } else {
                    exp = pos.min == pos.max ? (pos.min == 1L ? cc.function(Function.HEAD, this.info, rt) : cc.function(Function._UTIL_ITEM_AT, this.info, rt, Int.get(pos.min))) : cc.function(Function._UTIL_ITEM_RANGE, this.info, rt, Int.get(pos.min), Int.get(pos.max));
                }
            } else if (expr instanceof Pos) {
                pos = (Pos)expr;
                exp = ((Pos)pos).exprs[0] == ((Pos)pos).exprs[1] ? cc.function(Function._UTIL_ITEM_AT, this.info, rt, ((Pos)pos).exprs[0]) : cc.function(Function._UTIL_ITEM_RANGE, this.info, rt, ((Pos)pos).exprs[0], ((Pos)pos).exprs[1]);
            } else if (Filter.numeric(expr)) {
                exp = cc.function(Function._UTIL_ITEM_AT, this.info, rt, expr);
            }
            if (exp != null) {
                rt = exp;
                opt = true;
                continue;
            }
            rt = rt instanceof Filter ? ((Filter)rt).addPred(expr) : Filter.get(this.info, rt, expr);
        }
        if (opt) {
            return cc.replaceWith(this, rt);
        }
        exp = Filter.get(this.info, this.root, this.exprs);
        return exp instanceof ParseExpr ? this.copyType((ParseExpr)exp) : exp;
    }

    public final CachedFilter addPred(Expr pred) {
        this.exprs = (Expr[])((ExprList)((Object)((ExprList)new ExprList(this.exprs.length + 1).add(this.exprs)).add(pred))).finish();
        return this.copyType(new CachedFilter(this.info, this.root, this.exprs));
    }

    @Override
    public final Expr optimizeEbv(CompileContext cc) throws QueryException {
        Expr expr = this.optimizeEbv(this.root, cc);
        return expr == this ? super.optimizeEbv(cc) : cc.replaceEbv(this, expr);
    }

    private static Expr simplify(Expr root, Expr ... exprs) {
        if (exprs.length == 0) {
            return root;
        }
        if (root instanceof AxisPath && !Filter.positional(exprs)) {
            return ((AxisPath)root).addPreds(exprs);
        }
        return null;
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (this.root.has(flags)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean removable(Var var) {
        return this.root.removable(var) && super.removable(var);
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage inPreds = super.count(var);
        VarUsage inRoot = this.root.count(var);
        if (inPreds == VarUsage.NEVER) {
            return inRoot;
        }
        long size = this.root.size();
        return size == 0L || size == 1L || this.root.seqType().zeroOrOne() ? inRoot.plus(inPreds) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public final Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        Expr rt;
        boolean changed = Filter.inlineAll(this.exprs, var, ex, cc);
        if (this.root != null && (rt = this.root.inline(var, ex, cc)) != null) {
            this.root = rt;
            changed = true;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        for (Expr expr : this.exprs) {
            visitor.enterFocus();
            if (!expr.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return this.root.accept(visitor);
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.root.exprSize();
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Filter && this.root.equals(((Filter)obj).root) && super.equals(obj);
    }

    @Override
    public final void plan(FElem plan) {
        Filter.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.root, this.exprs});
    }

    @Override
    public final String toString() {
        return "(" + this.root + ')' + super.toString();
    }
}

