/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class CArray
extends Arr {
    private final boolean seq;

    public CArray(InputInfo info, boolean seq, Expr ... exprs) {
        super(info, SeqType.ARRAY_O, exprs);
        this.seq = seq;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        SeqType dt = null;
        for (Expr expr : this.exprs) {
            SeqType st = expr.seqType();
            if (!this.seq) {
                st = st.with(Occ.ONE);
            }
            dt = dt == null ? st : dt.union(st);
        }
        if (dt != null) {
            this.exprType.assign(ArrayType.get(dt));
        }
        return this.allAreValues(true) ? cc.preEval(this) : this;
    }

    @Override
    public Array item(QueryContext qc, InputInfo ii) throws QueryException {
        ArrayBuilder builder = new ArrayBuilder();
        if (this.seq) {
            for (Expr expr : this.exprs) {
                builder.append(expr.value(qc));
            }
        } else {
            for (Expr expr : this.exprs) {
                Item item;
                BasicIter<Item> iter = expr.value(qc).iter();
                while ((item = qc.next(iter)) != null) {
                    builder.append(item);
                }
            }
        }
        return builder.freeze();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CArray(this.info, this.seq, CArray.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CArray && this.seq == ((CArray)obj).seq && super.equals(obj);
    }

    @Override
    public String description() {
        return "array";
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        tb.add(this.seq ? "[ " : "array { ");
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            if (e != 0) {
                tb.add(", ");
            }
            tb.addExt(this.exprs[e], new Object[0]);
        }
        return tb.add(this.seq ? " ]" : "}").toString();
    }
}

