/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import org.basex.data.Data;
import org.basex.index.path.PathIndex;
import org.basex.index.path.PathNode;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Preds;
import org.basex.query.expr.Root;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.Union;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CDoc;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.IndexDynDb;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedPath;
import org.basex.query.expr.path.InvDocTest;
import org.basex.query.expr.path.IterPath;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.MixedPath;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public abstract class Path
extends ParseExpr {
    private static final EnumSet<Axis> EXPENSIVE = EnumSet.of(Axis.DESC, new Axis[]{Axis.DESCORSELF, Axis.PREC, Axis.PRECSIBL, Axis.FOLL, Axis.FOLLSIBL});
    public Expr root;
    public final Expr[] steps;

    protected Path(InputInfo info, Expr root, Expr[] steps) {
        super(info, SeqType.ITEM_ZM);
        this.root = root;
        this.steps = steps;
    }

    public static ParseExpr get(InputInfo info, Expr root, Expr ... steps) {
        Expr[] st;
        int sl = steps.length;
        ExprList list = new ExprList(sl);
        Expr rt = root;
        if (rt instanceof Path) {
            Expr[] path = (Expr[])rt;
            list.add(path.steps);
            rt = path.root;
        }
        if (rt instanceof ContextValue) {
            rt = null;
        }
        for (Expr expr : steps) {
            Expr step = expr;
            if (step instanceof ContextValue) {
                if (sl > 1) continue;
                step = Step.get(((ContextValue)step).info, Axis.SELF, KindTest.NOD, new Expr[0]);
            } else if (step instanceof Filter) {
                Filter f = (Filter)step;
                if (f.root instanceof ContextValue) {
                    step = Step.get(f.info, Axis.SELF, KindTest.NOD, f.exprs);
                }
            } else if (step instanceof Path) {
                Path p = (Path)step;
                if (p.root != null && !(p.root instanceof ContextValue)) {
                    list.add(p.root);
                }
                int pl = p.steps.length - 1;
                for (int i = 0; i < pl; ++i) {
                    list.add(p.steps[i]);
                }
                step = p.steps[pl];
            }
            list.add(step);
        }
        int axes = 0;
        for (Expr step : st = (Expr[])list.toArray()) {
            if (!(step instanceof Step)) continue;
            ++axes;
        }
        sl = st.length;
        if (axes == sl) {
            return Path.iterative(rt, st) ? new IterPath(info, rt, st) : new CachedPath(info, rt, st);
        }
        Expr last = st[sl - 1];
        if (sl > 1 && last.seqType().type.instanceOf(AtomType.AAT)) {
            list.remove(sl - 1);
            return (SimpleMap)SimpleMap.get(info, Path.get(info, rt, (Expr[])list.finish()), last);
        }
        return new MixedPath(info, rt, st);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        int ss = this.steps.length;
        for (int s = 0; s < ss - 1; ++s) {
            this.checkNoUp(this.steps[s]);
        }
        this.steps[ss - 1].checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        if (this.root != null) {
            this.root = this.root.compile(cc);
            if (this.root.seqType().zero() || this.steps.length == 0) {
                return this.root;
            }
            cc.pushFocus(this.root);
        } else {
            if (this.steps.length == 0) {
                return new ContextValue(this.info).optimize(cc);
            }
            cc.pushFocus(cc.qc.focus.value);
        }
        for (Expr step : this.steps) {
            try {
                step = step.compile(cc);
            }
            catch (QueryException ex) {
                step = cc.error(ex, this);
            }
            cc.updateFocus(step);
            this.steps[s] = step;
        }
        cc.removeFocus();
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        if (this.root != null && this.root.seqType().zero()) {
            return cc.replaceWith(this, this.root);
        }
        Value rt = this.rootValue(cc);
        if (this.emptyPath(rt)) {
            return cc.emptySeq(this);
        }
        this.seqType(cc, rt);
        Expr expr = this.mergeSteps(cc);
        if (expr == this) {
            expr = this.index(cc, rt);
        }
        if (expr == this) {
            expr = this.children(cc, rt);
        }
        if (expr != this) {
            return expr.optimize(cc);
        }
        return this.copyType(Path.get(this.info, this.root, this.steps));
    }

    @Override
    public Expr optimizeEbv(CompileContext cc) throws QueryException {
        Expr last = this.steps[this.steps.length - 1];
        if (last instanceof Step) {
            Expr s;
            Step step = (Step)last;
            if (step.exprs.length == 1 && step.seqType().type instanceof NodeType && !step.exprs[0].seqType().mayBeNumber() && (s = step.optimizeEbv(this, cc)) != step) {
                step.exprs = new Expr[0];
                return cc.replaceEbv(this, s);
            }
        }
        return super.optimizeEbv(cc);
    }

    @Override
    public Data data() {
        Data data;
        if (this.root != null && (data = this.root.data()) != null) {
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                if (this.axisStep(s) != null) continue;
                return null;
            }
            return data;
        }
        return null;
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.CTX.in(flags) && (this.root == null || this.root.has(Flag.CTX))) {
            return true;
        }
        if (Flag.POS.in(flags) && this.root != null && this.root.has(Flag.POS)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        if (flgs.length != 0) {
            for (Expr step : this.steps) {
                if (!step.has(flgs)) continue;
                return true;
            }
            return this.root != null && this.root.has(flgs);
        }
        return false;
    }

    private Step axisStep(int index) {
        return this.steps[index] instanceof Step ? (Step)this.steps[index] : null;
    }

    public final ArrayList<PathNode> pathNodes(CompileContext cc) {
        Value rt = this.rootValue(cc);
        if (rt == null || rt.type != NodeType.DOC || cc.nestedFocus() && cc.qc.focus.value == null) {
            return null;
        }
        Data data = rt.data();
        if (data == null || !data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            if ((nodes = curr.nodes(nodes, data)) != null) continue;
            return null;
        }
        return nodes;
    }

    private Value rootValue(CompileContext cc) {
        if (this.root == null) {
            return cc.qc.focus.value;
        }
        if (this.root instanceof Value) {
            return (Value)this.root;
        }
        return cc.dummyItem(this.root);
    }

    public final boolean cheap() {
        if (!(this.root instanceof ANode) || ((Value)this.root).type != NodeType.DOC) {
            return false;
        }
        int sl = this.steps.length;
        for (int i = 0; i < sl; ++i) {
            Step s = this.axisStep(i);
            if (s == null || i < 2 && EXPENSIVE.contains((Object)s.axis)) {
                return false;
            }
            Expr[] ps = s.exprs;
            if (ps.length == 0 || ps.length == 1 && ps[0] instanceof ItrPos) continue;
            return false;
        }
        return true;
    }

    private static boolean iterative(Expr root, Expr ... steps) {
        if (root == null || !root.iterable()) {
            return false;
        }
        long size = root.size();
        SeqType st = root.seqType();
        boolean atMostOne = size == 0L || size == 1L || st.zeroOrOne();
        boolean sameDepth = atMostOne || st.type == NodeType.DOC || st.type == NodeType.DEL;
        block10: for (Expr expr : steps) {
            Step step = (Step)expr;
            switch (step.axis) {
                case ANC: 
                case ANCORSELF: 
                case PREC: 
                case PRECSIBL: {
                    return false;
                }
                case FOLL: {
                    if (!atMostOne) {
                        return false;
                    }
                    atMostOne = false;
                    sameDepth = false;
                    continue block10;
                }
                case FOLLSIBL: {
                    if (!atMostOne) {
                        return false;
                    }
                    atMostOne = false;
                    continue block10;
                }
                case ATTR: {
                    atMostOne &= step.test.kind == Test.Kind.URI_NAME;
                    continue block10;
                }
                case CHILD: {
                    if (!sameDepth) {
                        return false;
                    }
                    atMostOne = false;
                    continue block10;
                }
                case DESC: 
                case DESCORSELF: {
                    if (!sameDepth) {
                        return false;
                    }
                    atMostOne = false;
                    sameDepth = false;
                    continue block10;
                }
                case PARENT: {
                    if (atMostOne) continue block10;
                    return false;
                }
                case SELF: {
                    continue block10;
                }
                default: {
                    throw Util.notExpected();
                }
            }
        }
        return true;
    }

    private void seqType(CompileContext cc, Value rt) {
        int sl = this.steps.length;
        long size = this.size(cc, rt);
        Expr last = this.steps[sl - 1];
        SeqType st = last.seqType();
        Type type = st.type;
        Occ occ = Occ.ZERO_MORE;
        if (size < 0L && this.root == null && sl == 1 && last instanceof Step && cc.nestedFocus()) {
            Step step = (Step)last;
            if (step.axis == Axis.ATTR && step.test.one) {
                occ = Occ.ZERO_ONE;
                step.exprType.assign(occ);
            }
        }
        this.exprType.assign(type, occ, size);
    }

    private long size(CompileContext cc, Value rt) {
        if (this.root != null && this.root.size() == 0L) {
            return 0L;
        }
        for (Expr step : this.steps) {
            if (step.size() != 0L) continue;
            return 0L;
        }
        if (rt == null || rt.type != NodeType.DOC || cc.nestedFocus() && cc.qc.focus.value == null) {
            return -1L;
        }
        Data data = rt.data();
        if (data == null || !data.meta.uptodate || (long)data.meta.ndocs != rt.size()) {
            return -1L;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        long lastSize = 1L;
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            Step curr = this.axisStep(s);
            if (curr != null) {
                if ((nodes = curr.nodes(nodes, data)) != null) continue;
                return -1L;
            }
            if (s + 1 == sl) {
                lastSize = this.steps[s].size();
                continue;
            }
            return -1L;
        }
        long size = 0L;
        for (PathNode pn : nodes) {
            size += (long)pn.stats.count;
        }
        return size * lastSize;
    }

    private ArrayList<PathNode> pathNodes(Data data, int last) {
        if (data == null || !data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        for (int s = 0; s <= last; ++s) {
            boolean desc;
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            boolean bl = desc = curr.axis == Axis.DESC;
            if (!desc && curr.axis != Axis.CHILD || curr.test.kind != Test.Kind.NAME) {
                return null;
            }
            int name = data.elemNames.id(curr.test.name.local());
            ArrayList<PathNode> tmp = new ArrayList<PathNode>();
            for (PathNode node : PathIndex.desc(nodes, desc)) {
                if (node.kind != 1 || name != node.name) continue;
                if (!tmp.isEmpty() && ((PathNode)tmp.get(0)).level() != node.level()) {
                    return null;
                }
                tmp.add(node);
            }
            if (tmp.isEmpty()) {
                return null;
            }
            nodes = tmp;
        }
        return nodes;
    }

    private boolean emptyPath(Value rt) {
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            if (!this.emptyStep(rt, s)) continue;
            return true;
        }
        return false;
    }

    private boolean emptyStep(Value rt, int s) {
        block22: {
            Axis axis;
            Step step;
            block20: {
                block21: {
                    if (this.steps[s] == Empty.SEQ) {
                        return true;
                    }
                    step = this.axisStep(s);
                    if (step == null) {
                        return false;
                    }
                    axis = step.axis;
                    if (s != 0) break block20;
                    if (!(this.root instanceof CAttr)) break block21;
                    if (axis == Axis.CHILD || axis == Axis.DESC) {
                        return true;
                    }
                    break block22;
                }
                if (!(this.root instanceof Root) && !(this.root instanceof CDoc) && (rt == null || rt.type != NodeType.DOC)) break block22;
                switch (axis) {
                    case ANCORSELF: 
                    case SELF: {
                        if (step.test != KindTest.NOD && step.test != KindTest.DOC) {
                            return true;
                        }
                        break block22;
                    }
                    case CHILD: 
                    case DESC: {
                        if (step.test == KindTest.DOC || step.test == KindTest.ATT) {
                            return true;
                        }
                        break block22;
                    }
                    case DESCORSELF: {
                        if (step.test == KindTest.ATT) {
                            return true;
                        }
                        break block22;
                    }
                    default: {
                        return true;
                    }
                }
            }
            Step last = this.axisStep(s - 1);
            if (last == null) {
                return false;
            }
            if (axis == Axis.SELF || axis == Axis.DESCORSELF) {
                if (step.test == KindTest.NOD) {
                    return false;
                }
                if (last.axis == Axis.ATTR && step.test.type != NodeType.ATT || last.test == KindTest.TXT && step.test != KindTest.TXT) {
                    return true;
                }
                if (axis == Axis.DESCORSELF) {
                    return false;
                }
                QNm name = step.test.name;
                QNm lastName = last.test.name;
                if (lastName == null || name == null || lastName.local().length == 0 || name.local().length == 0) {
                    return false;
                }
                return !name.eq(lastName);
            }
            if (axis == Axis.FOLLSIBL || axis == Axis.PRECSIBL) {
                return last.axis == Axis.ATTR;
            }
            if (axis == Axis.DESC || axis == Axis.CHILD || axis == Axis.ATTR) {
                return last.axis == Axis.ATTR || last.test == KindTest.TXT || last.test == KindTest.COM || last.test == KindTest.PI || axis == Axis.ATTR && step.test == KindTest.NSP;
            }
            if (axis == Axis.PARENT || axis == Axis.ANC) {
                return last.test == KindTest.DOC;
            }
        }
        return false;
    }

    private Expr children(CompileContext cc, Value rt) {
        ArrayList<PathNode> nodes;
        if (rt == null || rt.type != NodeType.DOC || cc.nestedFocus() && cc.qc.focus.value == null) {
            return this;
        }
        Data data = rt.data();
        if (data == null || !data.meta.uptodate || data.nspaces.globalUri() == null) {
            return this;
        }
        ParseExpr path = this;
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            ArrayList<PathNode> nodes2;
            Step prev;
            Step step = prev = s > 0 ? this.axisStep(s - 1) : null;
            if (prev != null && prev.exprs.length != 0) break;
            Step curr = this.axisStep(s);
            if (curr == null || curr.axis != Axis.DESC || curr.positional() || (nodes2 = this.pathNodes(data, s)) == null) continue;
            ArrayList<QNm> qnm = new ArrayList<QNm>();
            while (nodes2.get((int)0).parent != null) {
                QNm nm = new QNm(data.elemNames.key(nodes2.get((int)0).name));
                if (nm.hasPrefix()) {
                    return this;
                }
                for (PathNode p : nodes2) {
                    if (nodes2.get((int)0).name == p.name) continue;
                    nm = null;
                }
                qnm.add(nm);
                nodes2 = PathIndex.parent(nodes2);
            }
            cc.info("convert to child steps: %", this.steps[s]);
            int ts = qnm.size();
            Expr[] stps = new Expr[ts + sl - s - 1];
            for (int t = 0; t < ts; ++t) {
                Expr[] preds = t == ts - 1 ? ((Preds)this.steps[s]).exprs : new Expr[]{};
                QNm nm = (QNm)qnm.get(ts - t - 1);
                NameTest nt = nm == null ? new NameTest(false) : new NameTest(nm, Test.Kind.NAME, false, null);
                stps[t] = Step.get(this.info, Axis.CHILD, nt, preds);
            }
            while (++s < sl) {
                stps[ts++] = this.steps[s];
            }
            path = Path.get(this.info, this.root, stps);
            break;
        }
        if ((nodes = this.pathNodes(cc)) != null && nodes.isEmpty()) {
            cc.info("remove non-existing path %", path);
            return Empty.SEQ;
        }
        return path;
    }

    private Expr index(CompileContext cc, Value rt) throws QueryException {
        Expr resultRoot;
        Step step;
        if (rt != null && rt.type != NodeType.DOC || cc.nestedFocus() && cc.qc.focus.value != null) {
            return this;
        }
        IndexInfo index = null;
        int indexPred = 0;
        int indexStep = 0;
        Data data = rt != null ? rt.data() : null;
        int sl = this.steps.length;
        for (int s = 0; s < sl && (step = this.axisStep(s)) != null && step.axis.down && !step.positional(); ++s) {
            boolean iter;
            int el = step.exprs.length;
            if (el <= 0) continue;
            boolean bl = iter = this.pathNodes(data, s) != null;
            IndexDb db = data != null ? new IndexStaticDb(data, iter, this.info) : new IndexDynDb(this.info, iter, this.root == null ? new ContextValue(this.info) : this.root);
            for (int e = 0; e < el; ++e) {
                IndexInfo ii = new IndexInfo(db, cc.qc, step);
                if (!step.exprs[e].indexAccessible(ii)) continue;
                if (ii.costs.results() == 0) {
                    cc.info("no index results: %", ii.step);
                    return Empty.SEQ;
                }
                if (index != null && index.costs.compareTo(ii.costs) <= 0) continue;
                index = ii;
                indexPred = e;
                indexStep = s;
            }
        }
        if (index == null || data != null && index.costs.tooExpensive(data)) {
            return this;
        }
        if (rt instanceof Dummy && !index.enforce()) {
            return this;
        }
        cc.info(index.optInfo, new Object[0]);
        ExprList newPreds = new ExprList();
        Test rootTest = InvDocTest.get(rt);
        ExprList invSteps = new ExprList();
        if (rootTest != KindTest.DOC || data == null || !data.meta.uptodate || this.predSteps(data, indexStep)) {
            for (int s = indexStep; s >= 0; --s) {
                Axis invAxis = this.axisStep((int)s).axis.invert();
                if (s == 0) {
                    if (rootTest == KindTest.DOC && (invAxis == Axis.ANC || invAxis == Axis.ANCORSELF)) continue;
                    invSteps.add(Step.get(this.info, invAxis, rootTest, new Expr[0]));
                    continue;
                }
                Step prevStep = this.axisStep(s - 1);
                Axis newAxis = prevStep.axis == Axis.ATTR ? Axis.ATTR : invAxis;
                invSteps.add(Step.get(this.info, newAxis, prevStep.test, prevStep.exprs));
            }
        }
        if (!invSteps.isEmpty()) {
            newPreds.add(Path.get(this.info, null, (Expr[])invSteps.finish()));
        }
        Expr[] preds = index.step.exprs;
        int pl = preds.length;
        for (int p = 0; p < pl; ++p) {
            if (p == indexPred) continue;
            newPreds.add(preds[p]);
        }
        ExprList resultSteps = new ExprList();
        if (index.expr instanceof Path) {
            Path path = (Path)index.expr;
            resultRoot = path.root;
            resultSteps.add(path.steps);
        } else {
            resultRoot = index.expr;
        }
        if (index.costs.results() == 1) {
            Occ occ = resultRoot instanceof IndexAccess ? Occ.ONE : Occ.ZERO_ONE;
            ((ParseExpr)resultRoot).exprType.assign(occ);
        }
        if (!newPreds.isEmpty()) {
            Step step2;
            int ls = resultSteps.size() - 1;
            if (ls < 0 || !(resultSteps.get(ls) instanceof Step)) {
                step2 = Step.get(this.info, Axis.SELF, KindTest.NOD, new Expr[0]);
                ++ls;
            } else {
                step2 = (Step)resultSteps.get(ls);
            }
            resultSteps.set(ls, step2.addPreds((Expr[])newPreds.finish()));
        }
        for (int s = indexStep + 1; s < sl; ++s) {
            resultSteps.add(this.steps[s]);
        }
        return resultSteps.isEmpty() ? resultRoot : Path.get(this.info, resultRoot, (Expr[])resultSteps.finish());
    }

    private boolean predSteps(Data data, int i) {
        for (int s = i; s >= 0; --s) {
            Step step = this.axisStep(s);
            if (step.test.kind == Test.Kind.WILDCARD && s != i) continue;
            if (step.test.kind != Test.Kind.NAME || step.axis != Axis.CHILD || s != i && step.exprs.length > 0) {
                return true;
            }
            ArrayList<PathNode> pn = data.paths.desc(step.test.name.local());
            if (pn.size() == 1 && pn.get(0).level() == s + 1) continue;
            return true;
        }
        return false;
    }

    private Expr mergeSteps(CompileContext cc) {
        boolean opt = false;
        int sl = this.steps.length;
        ExprList stps = new ExprList(sl);
        for (int s = 0; s < sl; ++s) {
            Step curr;
            Expr step = this.steps[s];
            if (s < sl - 1 && step instanceof Step && (curr = (Step)step).simple(Axis.DESCORSELF, false)) {
                Expr next = this.steps[s + 1];
                if (Path.simpleChild(next)) {
                    ((Step)next).axis = Axis.DESC;
                    opt = true;
                    continue;
                }
                Expr expr = this.mergeList(next);
                if (expr != null) {
                    this.steps[s + 1] = expr;
                    opt = true;
                    continue;
                }
                if (next instanceof Filter && !((Filter)next).positional()) {
                    Filter f = (Filter)next;
                    expr = this.mergeList(f.root);
                    if (expr != null) {
                        f.root = expr;
                        opt = true;
                        continue;
                    }
                }
            }
            stps.add(step);
        }
        if (opt) {
            cc.info("rewrite descendant-or-self step(s)", new Object[0]);
            return stps.isEmpty() ? this.root : Path.get(this.info, this.root, (Expr[])stps.finish());
        }
        return this;
    }

    private Expr mergeList(Expr expr) {
        Arr array;
        if ((expr instanceof Union || expr instanceof List) && Path.childSteps(array = (Arr)expr)) {
            for (Expr ex : array.exprs) {
                ((Step)((Path)ex).steps[0]).axis = Axis.DESC;
            }
            return new Union(array.info, array.exprs);
        }
        return null;
    }

    private static boolean childSteps(Arr array) {
        for (Expr expr : array.exprs) {
            if (!(expr instanceof Path)) {
                return false;
            }
            Path path = (Path)expr;
            if (path.root == null && Path.simpleChild(path.steps[0])) continue;
            return false;
        }
        return true;
    }

    private static boolean simpleChild(Expr expr) {
        if (expr instanceof Step) {
            Step step = (Step)expr;
            if (step.axis == Axis.CHILD && !step.positional()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean removable(Var var) {
        for (Expr step : this.steps) {
            if (!step.uses(var)) continue;
            return false;
        }
        return this.root == null || this.root.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        VarUsage inRoot = this.root == null ? VarUsage.NEVER : this.root.count(var);
        return VarUsage.sum(var, this.steps) == VarUsage.NEVER ? inRoot : VarUsage.MORE_THAN_ONCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        Expr rt;
        boolean changed = false;
        if (this.root != null && (rt = this.root.inline(var, ex, cc)) != null) {
            this.root = rt;
            changed = true;
        }
        cc.pushFocus(this.root != null ? this.root : cc.qc.focus.value);
        try {
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                Expr exp = this.steps[s].inline(var, ex, cc);
                if (exp != null) {
                    this.steps[s] = exp;
                    changed = true;
                }
                cc.updateFocus(this.steps[s]);
            }
        }
        finally {
            cc.removeFocus();
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (this.root == null) {
            visitor.lock("%CONTEXT");
        } else if (!this.root.accept(visitor)) {
            return false;
        }
        visitor.enterFocus();
        if (!Path.visitAll(visitor, this.steps)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr step : this.steps) {
            size += step.exprSize();
        }
        return this.root == null ? size : size + this.root.exprSize();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path path = (Path)obj;
        return Objects.equals(this.root, path.root) && Array.equals(this.steps, path.steps);
    }

    @Override
    public final void plan(FElem plan) {
        Path.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.root, this.steps});
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            sb.append(this.root);
        }
        for (Expr step : this.steps) {
            String s;
            boolean par;
            if (sb.length() != 0) {
                sb.append('/');
            }
            boolean bl = par = !(s = step.toString()).contains("[") && s.contains(" ");
            if (par) {
                sb.append('(');
            }
            sb.append(step);
            if (!par) continue;
            sb.append(')');
        }
        return sb.toString();
    }
}

