/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.convert;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.AtomType;

public final class ConvertBinaryToIntegers
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final byte[] bytes = this.toBin(this.exprs[0], qc).binary(this.info);
        return new BasicIter<Int>((long)bytes.length){

            @Override
            public Int get(long i) {
                return Int.get(bytes[(int)i] & 0xFF);
            }

            @Override
            public Value value(QueryContext q) {
                return ConvertBinaryToIntegers.toValue(bytes);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return ConvertBinaryToIntegers.toValue(this.toBin(this.exprs[0], qc).binary(this.info));
    }

    public static Value toValue(byte[] bytes) {
        int bl = bytes.length;
        if (bl == 1) {
            return Int.get(bytes[0] & 0xFF);
        }
        long[] tmp = new long[bl];
        for (int b = 0; b < bl; ++b) {
            tmp[b] = bytes[b] & 0xFF;
        }
        return IntSeq.get(tmp, AtomType.ITR);
    }
}

