/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.Date;
import org.basex.core.Databases;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.node.FElem;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class DbBackups
extends StandardFunc {
    private static final String BACKUP = "backup";
    private static final String SIZE = "size";
    private static final String DATE = "date";
    private static final String DATABASE = "database";

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        String name = this.exprs.length == 0 ? null : Token.string(this.toToken(this.exprs[0], qc));
        final StringList backups = name == null ? qc.context.databases.backups() : qc.context.databases.backups(name);
        final IOFile dbpath = qc.context.soptions.dbPath();
        return new Iter(){
            int up = -1;

            @Override
            public FElem next() throws QueryException {
                if (++this.up >= backups.size()) {
                    return null;
                }
                String backup = (String)backups.get(this.up);
                long length = new IOFile(dbpath, backup + ".zip").length();
                String db = Databases.name(backup);
                Date date = Databases.date(backup);
                String ymd = DateTime.format(date, DateTime.DATE);
                String hms = DateTime.format(date, DateTime.TIME);
                Dtm dtm = new Dtm(Token.token(ymd + 'T' + hms), DbBackups.this.info);
                return new FElem(DbBackups.BACKUP).add(backup).add(DbBackups.DATABASE, db).add(DbBackups.DATE, dtm.string(DbBackups.this.info)).add(DbBackups.SIZE, Token.token(length));
            }
        };
    }
}

