/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.math.BigInteger;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public class FnSum
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr expr = this.exprs[0];
        if (expr instanceof RangeSeq || expr instanceof Range) {
            Item item = this.range(expr.value(qc));
            if (item != null) {
                return item;
            }
        } else {
            Item item;
            if (expr instanceof SingletonSeq && (item = this.singleton((SingletonSeq)expr)) != null) {
                return item;
            }
            Iter iter = this.exprs[0].atomIter(qc, this.info);
            Item item2 = iter.next();
            if (item2 != null) {
                return this.sum(iter, item2, false, qc);
            }
        }
        return this.exprs.length == 2 ? this.exprs[1].atomItem(qc, this.info) : Int.ZERO;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqType st2;
        Item item;
        Expr expr2;
        Expr expr1 = this.exprs[0];
        Expr expr = expr2 = this.exprs.length == 2 ? this.exprs[1] : null;
        if (expr1 instanceof RangeSeq) {
            return this.range((Value)expr1);
        }
        if (expr1 instanceof SingletonSeq && (item = this.singleton((SingletonSeq)expr1)) != null) {
            return item;
        }
        SeqType st1 = expr1.seqType();
        SeqType seqType = st2 = expr2 != null ? expr2.seqType() : null;
        if (st1.zero()) {
            if (!expr1.has(Flag.NDT)) {
                if (expr2 == null) {
                    return Int.ZERO;
                }
                if (expr2 == Empty.SEQ) {
                    return expr1;
                }
                if (st2.instanceOf(SeqType.ITR_O)) {
                    return expr2;
                }
            }
        } else if (st1.oneOrMore() && !st1.mayBeArray()) {
            Type type1 = st1.type;
            if (type1.isNumber()) {
                this.exprType.assign(type1.seqType());
            }
            if (type1.isUntyped()) {
                this.exprType.assign(SeqType.DBL_O);
            }
        } else if (st2 != null && !st2.zero() && !st2.mayBeArray()) {
            Type type1 = st1.type;
            Type type2 = st2.type;
            AtomType type = type1.isNumberOrUntyped() && type2.isNumberOrUntyped() ? Calc.type(type1, type2) : AtomType.AAT;
            this.exprType.assign((Type)type, st2.one() ? Occ.ONE : Occ.ZERO_ONE);
        }
        return this;
    }

    private Item range(Value value) throws QueryException {
        long l;
        BigInteger be;
        long max;
        if (value.isEmpty()) {
            return null;
        }
        long min = value.itemAt(0L).itr(this.info);
        if (min > (max = value.itemAt(value.size() - 1L).itr(this.info))) {
            long t = max;
            max = min;
            min = t;
        }
        if (max < 3037000500L) {
            return Int.get((min + max) * (max - min + 1L) / 2L);
        }
        BigInteger bs = BigInteger.valueOf(min);
        BigInteger bi = bs.add(be = BigInteger.valueOf(max)).multiply(be.subtract(bs).add(BigInteger.ONE)).divide(BigInteger.valueOf(2L));
        if (bi.equals(BigInteger.valueOf(l = bi.longValue()))) {
            return Int.get(l);
        }
        throw QueryError.RANGE_X.get(this.info, bi);
    }

    private Item singleton(SingletonSeq seq) throws QueryException {
        Item item = seq.itemAt(0L);
        if (item.type.isUntyped()) {
            item = Dbl.get(item.dbl(this.info));
        }
        return item.type.isNumber() ? Calc.MULT.eval(item, Int.get(seq.size()), this.info) : null;
    }

    Item sum(Iter iter, Item item, boolean avg, QueryContext qc) throws QueryException {
        Item it;
        boolean ymd;
        Item res = item.type.isUntyped() ? Dbl.get(item.dbl(this.info)) : item;
        boolean num = res instanceof ANum;
        boolean dtd = res.type == AtomType.DTD;
        boolean bl = ymd = res.type == AtomType.YMD;
        if (!(num || dtd || ymd)) {
            throw QueryError.SUM_X_X.get(this.info, res.type, res);
        }
        int c = 1;
        while ((it = qc.next(iter)) != null) {
            Type type = it.type;
            AtomType tp = null;
            if (type.isNumberOrUntyped()) {
                if (!num) {
                    tp = AtomType.DUR;
                }
            } else if (num) {
                tp = AtomType.NUM;
            } else if (dtd && type != AtomType.DTD || ymd && type != AtomType.YMD) {
                tp = AtomType.DUR;
            }
            if (tp != null) {
                throw QueryError.CMP_X_X_X.get(this.info, tp, type, it);
            }
            res = Calc.PLUS.eval(res, it, this.info);
            ++c;
        }
        return avg ? Calc.DIV.eval(res, Int.get(c), this.info) : res;
    }
}

