/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.util.InputInfo;

public final class SingletonSeq
extends Seq {
    public final Value value;

    private SingletonSeq(long size, Value value) {
        super(size, value.type);
        this.value = value;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo info) throws QueryException {
        return this.value.ebv(qc, info);
    }

    @Override
    public boolean homogeneous() {
        return this.value.homogeneous();
    }

    @Override
    public void materialize(InputInfo info) throws QueryException {
        this.value.materialize(info);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo info) throws QueryException {
        return SingletonSeq.get(this.value.atomValue(qc, info), this.size);
    }

    @Override
    public long atomSize() {
        return this.value.atomSize();
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        return this.value.size() == 1L ? new SingletonSeq(length, this.value) : super.subSeq(offset, length, qc);
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return item.equals(this.value) ? SingletonSeq.get(this.value, this.size + 1L) : this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return this.value.size() == 1L ? SingletonSeq.get(this.value, this.size - 1L) : this.copyRemove(pos, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        if (this.value.size() == 1L) {
            return this;
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (long i = 0L; i < this.size; ++i) {
            vb.add(this.itemAt(this.size - i - 1L));
        }
        return vb.value(this.type);
    }

    @Override
    public Item itemAt(long pos) {
        return this.value.itemAt(pos % this.value.size());
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem("size", this.size, "type", this.seqType());
        SingletonSeq.addPlan(plan, elem, new ExprInfo[0]);
        this.value.plan(elem);
    }

    @Override
    public String description() {
        return "singleton " + super.description();
    }

    @Override
    public String toString() {
        return Function._UTIL_REPLICATE.args(this.value, this.size / this.value.size()).substring(1);
    }

    public static Value get(Value value, long count) {
        if (count == 1L) {
            return value;
        }
        long vs = value.size();
        long size = vs * count;
        if (size == 0L) {
            return Empty.SEQ;
        }
        Value val = value;
        if (val instanceof SingletonSeq) {
            val = ((SingletonSeq)val).value;
        } else if (vs > 1L && val.homogeneous()) {
            Item it = val.itemAt(0L);
            int v = 0;
            while ((long)(++v) < vs && it.equals(val.itemAt(v))) {
            }
            if ((long)v == vs) {
                val = it;
            }
        }
        return size == 1L ? val : new SingletonSeq(size, val);
    }
}

