/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.util.Locale;
import org.basex.api.xmldb.BXCollection;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Set;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public final class BXDatabase
implements Database {
    final Context ctx = new Context();

    public boolean acceptsURI(String uri) throws XMLDBException {
        this.getCollectionName(uri);
        return true;
    }

    public Collection getCollection(String uri, String user, String password) throws XMLDBException {
        String name = this.getCollectionName(uri);
        boolean exists = this.ctx.soptions.dbExists(name);
        return exists ? new BXCollection(name, true, this) : null;
    }

    public String getConformanceLevel() {
        return "0";
    }

    public String getName() {
        return Prop.PROJECT_NAME;
    }

    public String getProperty(String name) {
        Object value = Get.get((String)name.toUpperCase(Locale.ENGLISH), (Context)this.ctx);
        return value == null ? null : value.toString();
    }

    public void setProperty(String name, String value) throws XMLDBException {
        try {
            new Set(name, (Object)value).execute(this.ctx);
        }
        catch (BaseXException ex) {
            Util.debug((Throwable)ex);
            throw new XMLDBException(1, "Property could not be set: " + name);
        }
    }

    private String getCollectionName(String uri) throws XMLDBException {
        if (uri != null) {
            String main;
            String string = main = uri.startsWith("xmldb:") ? uri : "xmldb:" + uri;
            if (main.startsWith(BXXMLDBText.XMLDBURI)) {
                String host = main.substring(BXXMLDBText.XMLDBURI.length());
                int port = this.ctx.soptions.get(StaticOptions.SERVERPORT);
                String localhost = "localhost:" + port + '/';
                if (host.startsWith(localhost)) {
                    return host.substring(localhost.length());
                }
            }
        }
        throw new XMLDBException(5, "Invalid URI: " + uri);
    }
}

