/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.util.HashMap;
import java.util.Map;
import org.basex.api.xmldb.BXCollection;
import org.basex.api.xmldb.BXResourceSet;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.value.Value;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XPathQueryService;

public final class BXQueryService
implements XPathQueryService {
    static final String XPATH = "XPathQueryService";
    static final String XQUERY = "XQueryQueryService";
    private final HashMap<String, String> ns = new HashMap();
    private final String name;
    private final String version;
    private BXCollection coll;

    BXQueryService(BXCollection coll, String name, String version) {
        this.coll = coll;
        this.name = name;
        this.version = version;
    }

    public void setNamespace(String prefix, String uri) throws XMLDBException {
        if (uri == null || uri.isEmpty()) {
            throw new XMLDBException(1, "Namespace URI is empty: " + prefix);
        }
        this.ns.put(prefix == null ? "" : prefix, uri);
    }

    public String getNamespace(String prefix) {
        return this.ns.get(prefix == null ? "" : prefix);
    }

    public void removeNamespace(String prefix) {
        this.ns.remove(prefix == null ? "" : prefix);
    }

    public void clearNamespaces() {
        this.ns.clear();
    }

    public BXResourceSet query(String query) throws XMLDBException {
        Data data = this.coll.data;
        return this.query(query, DBNodeSeq.get((IntList)data.resources.docs(), (Data)data, (boolean)true, (boolean)true));
    }

    public BXResourceSet queryResource(String id, String query) throws XMLDBException {
        BXXMLResource xml = this.coll.getResource(id);
        if (xml != null) {
            return this.query(query, (Value)new DBNode(xml.data, xml.pre));
        }
        throw new XMLDBException(1, "Resource not found: " + id);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCollection(Collection col) {
        this.coll = (BXCollection)col;
    }

    public String getProperty(String nm) {
        return null;
    }

    public void setProperty(String nm, String value) throws XMLDBException {
        throw new XMLDBException(1, "Property could not be set: " + nm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private BXResourceSet query(String query, Value nodes) throws XMLDBException {
        Context ctx = this.coll.ctx;
        try {
            Throwable throwable = null;
            try (QueryProcessor qp = new QueryProcessor(query, ctx);){
                BXResourceSet bXResourceSet;
                qp.context(nodes);
                qp.parse();
                try {
                    qp.register(ctx);
                    for (Map.Entry<String, String> entry : this.ns.entrySet()) {
                        qp.sc.ns.add(Token.token((String)entry.getKey()), Token.token((String)entry.getValue()), null);
                    }
                    bXResourceSet = new BXResourceSet(qp.value(), this.coll);
                }
                catch (Throwable throwable2) {
                    try {
                        qp.close();
                        qp.unregister(ctx);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                qp.close();
                qp.unregister(ctx);
                return bXResourceSet;
            }
        }
        catch (QueryException ex) {
            throw new XMLDBException(1, ex.getMessage());
        }
    }
}

