/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import javax.servlet.http.HttpServletRequest;
import org.basex.http.HTTPConnection;
import org.basex.http.webdav.WebDAVDatabase;
import org.basex.http.webdav.WebDAVFile;
import org.basex.http.webdav.WebDAVFolder;
import org.basex.http.webdav.WebDAVMetaData;
import org.basex.http.webdav.WebDAVNotAuthorized;
import org.basex.http.webdav.WebDAVRoot;
import org.basex.http.webdav.WebDAVService;
import org.basex.server.LoginException;
import org.basex.util.Util;

final class WebDAVFactory
implements ResourceFactory {
    private static final ThreadLocal<WebDAVService> SERVICES = new ThreadLocal();

    WebDAVFactory() {
    }

    static void init(HTTPConnection conn) {
        SERVICES.set(new WebDAVService(conn));
    }

    static void close() {
        SERVICES.get().close();
        SERVICES.remove();
    }

    public Resource getResource(String host, String dbpath) {
        try {
            WebDAVService service = SERVICES.get();
            HttpServletRequest r = service.conn.req;
            Path p = Path.path((String)dbpath);
            if (!r.getContextPath().isEmpty()) {
                p = p.getStripFirst();
            }
            if (!r.getServletPath().isEmpty()) {
                p = p.getStripFirst();
            }
            if (p.isRoot()) {
                return new WebDAVRoot(service);
            }
            String db = p.getFirst();
            return p.getLength() > 1 ? service.resource(db, p.getStripFirst().toString()) : (service.dbExists(db) ? new WebDAVDatabase(new WebDAVMetaData(db, service.timestamp(db)), service) : null);
        }
        catch (LoginException ex) {
            Util.debug((Throwable)ex);
            return WebDAVNotAuthorized.NOAUTH;
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            return null;
        }
    }

    static WebDAVFile file(WebDAVService s, WebDAVMetaData d) {
        return new WebDAVFile(d, s);
    }

    static WebDAVFolder folder(WebDAVService s, WebDAVMetaData d) {
        return new WebDAVFolder(d, s);
    }

    static WebDAVDatabase database(WebDAVService s, WebDAVMetaData d) {
        return new WebDAVDatabase(d, s);
    }
}

