/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import org.basex.gui.text.TextEditor;
import org.basex.util.FTToken;
import org.basex.util.Token;
import org.basex.util.list.IntList;

final class TextIterator {
    final byte[] text;
    private final int length;
    private final int caret;
    private final int start;
    private final int end;
    private final int errPos;
    private final IntList[] searchResults;
    private int pos;
    private int posEnd;
    private int searchIndex;
    private boolean link;

    TextIterator(TextEditor et) {
        this.text = et.text();
        this.length = this.text.length;
        this.caret = et.pos();
        this.start = et.start;
        this.end = et.end;
        this.errPos = et.error;
        this.searchResults = et.searchResults;
    }

    boolean moreStrings(int max) {
        int p;
        int l = this.length;
        this.pos = p = this.posEnd;
        if (p >= l) {
            return false;
        }
        int e = this.pos + max;
        byte[] txt = this.text;
        int ch = Token.cp(txt, p);
        p += Token.cl(txt, p);
        if (FTToken.lod(ch)) {
            while (p < l && p < e && FTToken.lod(ch = Token.cp(txt, p))) {
                p += Token.cl(txt, p);
            }
        }
        this.posEnd = p;
        return true;
    }

    String currString() {
        return this.posEnd <= this.length ? Token.string(this.text, this.pos, this.posEnd - this.pos) : "";
    }

    boolean caretLine(boolean first) {
        for (int p = this.pos + (first ? 0 : 1); p < this.length; ++p) {
            if (p == this.caret) {
                return true;
            }
            if (this.text[p] != 10) continue;
            return false;
        }
        return this.caret == this.length;
    }

    int curr() {
        return Token.cp(this.text, this.pos);
    }

    int pos() {
        return this.pos;
    }

    void pos(int p) {
        this.pos = p;
    }

    void posEnd(int p) {
        this.posEnd = p;
    }

    boolean more() {
        return this.pos < this.posEnd;
    }

    int next() {
        int c = this.curr();
        this.pos += Token.cl(this.text, this.pos);
        return c;
    }

    boolean edited() {
        return this.caret >= this.pos && this.caret < this.posEnd;
    }

    int caret() {
        return this.caret;
    }

    boolean selectStart() {
        return this.start != this.end && (this.inSelect() || (this.start < this.end ? this.start >= this.pos && this.start < this.posEnd : this.end >= this.pos && this.end < this.posEnd));
    }

    boolean inSelect() {
        return this.start < this.end ? this.pos >= this.start && this.pos < this.end : this.pos >= this.end && this.pos < this.start;
    }

    boolean searchStart() {
        if (this.searchResults == null) {
            return false;
        }
        if (this.searchIndex == this.searchResults[0].size()) {
            return false;
        }
        while (this.pos > this.searchResults[1].get(this.searchIndex)) {
            if (++this.searchIndex != this.searchResults[0].size()) continue;
            return false;
        }
        return this.posEnd > this.searchResults[0].get(this.searchIndex);
    }

    boolean inSearch() {
        boolean in;
        IntList starts = this.searchResults[0];
        IntList ends = this.searchResults[1];
        int i = this.searchIndex;
        if (i >= starts.size() || this.pos < starts.get(i)) {
            return false;
        }
        boolean bl = in = this.pos < ends.get(i);
        if (!in) {
            ++this.searchIndex;
        }
        return in;
    }

    boolean erroneous() {
        return this.errPos >= this.pos && this.errPos < this.posEnd;
    }

    int error() {
        return this.errPos;
    }

    void link(boolean lnk) {
        this.link = lnk;
    }

    String link() {
        int ls;
        if (!this.link) {
            return null;
        }
        int le = ls = this.pos;
        while (--ls > 0 && (this.text[ls] < -64 || Token.cp(this.text, ls) != 63739)) {
        }
        while (++le < this.length && (this.text[le] < -64 || Token.cp(this.text, le) != 63739)) {
        }
        ls += Token.cl(this.text, ls);
        return Token.string(this.text, ls, le - ls);
    }
}

