/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.core.cmd.Test;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.project.ProjectFile;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class ProjectList
extends JList<String> {
    private static FontMetrics fm;
    final GUIPopupCmd[] commands = new GUIPopupCmd[]{new GUIPopupCmd(Text.OPEN, new BaseXKeys[]{BaseXKeys.ENTER}){

        @Override
        public void execute() {
            ProjectList.this.open();
        }
    }, new GUIPopupCmd(Text.OPEN_EXTERNALLY, new BaseXKeys[]{BaseXKeys.SHIFT_ENTER}){

        @Override
        public void execute() {
            ProjectList.this.openExternal();
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectList.this.selectedValue() != null;
        }
    }, null, new GUIPopupCmd(Text.RUN_TESTS, new BaseXKeys[]{BaseXKeys.UNIT}){

        @Override
        public void execute() {
            ProjectList.this.test();
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectList.this.selectedValue() != null;
        }
    }, null, new GUIPopupCmd(Text.REFRESH, new BaseXKeys[]{BaseXKeys.REFRESH}){

        @Override
        public void execute() {
            ProjectList.this.view.refresh();
        }
    }, null, new GUIPopupCmd(Text.COPY_PATH, new BaseXKeys[]{BaseXKeys.COPYPATH}){

        @Override
        public void execute() {
            BaseXLayout.copyPath(ProjectList.this.selectedValue());
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectList.this.selectedValue() != null;
        }
    }};
    private final ProjectView view;
    private String search = "";

    ProjectList(ProjectView view) {
        this.view = view;
        this.setBorder(BaseXLayout.border(4, 4, 4, 4));
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(e -> {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                this.open();
            }
        });
        new BaseXPopup(this, view.gui, (GUICommand[])this.commands);
    }

    void setElements(String[] list, String srch) {
        int ll = list.length;
        ListModel model = this.getModel();
        int ms = model.getSize();
        boolean same = ll == ms;
        for (int l = 0; same && l < ll; ++l) {
            same = list[l].equals(model.getElementAt(l));
        }
        if (!same) {
            this.setListData(list);
            if (ll > 0) {
                this.setSelectedIndex(0);
            }
        }
        this.search = srch;
    }

    private void open() {
        for (String file : this.selectedValues()) {
            this.view.open(new IOFile(file), this.search);
        }
    }

    private void openExternal() {
        StringList files = this.selectedValues();
        if (files.isEmpty()) {
            return;
        }
        IOFile file = new IOFile((String)files.get(0));
        try {
            file.open();
        }
        catch (IOException ex) {
            Util.debug(ex);
            BaseXDialog.error(this.view.gui, Util.info(Text.FILE_NOT_OPENED_X, file));
        }
    }

    private void test() {
        for (String file : this.selectedValues()) {
            this.view.gui.execute(new Test(file));
        }
    }

    private String selectedValue() {
        List vals = this.getSelectedValuesList();
        return vals.size() == 1 ? (String)vals.get(0) : null;
    }

    private StringList selectedValues() {
        if (this.isSelectionEmpty() && this.getModel().getSize() != 0) {
            this.setSelectedIndex(0);
        }
        StringList sl = new StringList();
        for (String val : this.getSelectedValuesList()) {
            sl.add(val);
        }
        return sl;
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private final BaseXLabel label;
        private IOFile file = new IOFile(".");

        CellRenderer() {
            this.label = new BaseXLabel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    BaseXLayout.hints(g);
                    if (fm == null) {
                        fm = g.getFontMetrics(CellRenderer.this.label.getFont());
                    }
                    int y = Math.min(fm.getHeight(), (int)CellRenderer.this.label.getPreferredSize().getHeight()) - 2;
                    int x = (int)CellRenderer.this.label.getPreferredSize().getWidth() + 2;
                    String s = CellRenderer.this.file.name();
                    g.setColor(GUIConstants.TEXT);
                    g.drawString(s, x, y);
                    x += fm.stringWidth(s);
                    String[] names = CellRenderer.this.file.file().getParent().split("[/\\\\]");
                    StringBuilder sb = new StringBuilder(" \u00b7 ");
                    for (int n = names.length - 1; n >= 0; --n) {
                        sb.append(names[n]);
                        if (n <= 0) continue;
                        sb.append('/');
                    }
                    g.setColor(GUIConstants.dgray);
                    g.drawString(sb.toString(), x, y);
                }
            };
            this.label.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean selected, boolean expanded) {
            this.file = new IOFile(value.toString());
            this.label.setIcon(BaseXImages.file(this.file));
            this.label.setText("");
            this.label.setToolTipText(ProjectFile.toString(this.file, true));
            if (selected) {
                this.label.setBackground(ProjectList.this.getSelectionBackground());
                this.label.setForeground(ProjectList.this.getSelectionForeground());
            } else {
                this.label.setBackground(GUIConstants.BACK);
                this.label.setForeground(GUIConstants.TEXT);
            }
            return this.label;
        }
    }
}

