/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public abstract class Arr
extends ParseExpr {
    public Expr[] exprs;

    protected Arr(InputInfo info, SeqType seqType, Expr ... exprs) {
        super(info, seqType);
        this.exprs = exprs;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = this.exprs[e].compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Expr expr : this.exprs) {
            if (!expr.has(flags)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removable(Var var) {
        for (Expr expr : this.exprs) {
            if (expr.removable(var)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.exprs);
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        return Arr.inlineAll(this.exprs, var, ex, cc) ? this.optimize(cc) : null;
    }

    public static <T extends Expr> T[] copyAll(CompileContext cc, IntObjMap<Var> vm, T[] arr) {
        Expr[] copy = (Expr[])arr.clone();
        int cl = copy.length;
        for (int c = 0; c < cl; ++c) {
            copy[c] = copy[c].copy(cc, vm);
        }
        return copy;
    }

    protected final boolean allAreValues(boolean limit) {
        for (Expr expr : this.exprs) {
            if (expr instanceof Value && (!limit || expr.size() <= 262144L)) continue;
            return false;
        }
        return true;
    }

    protected final boolean oneIsEmpty() {
        for (Expr expr : this.exprs) {
            if (expr != Empty.SEQ) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Arr.visitAll(visitor, this.exprs);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Arr && Array.equals(this.exprs, ((Arr)obj).exprs);
    }

    @Override
    public void plan(FElem plan) {
        Arr.addPlan(plan, this.planElem(new Object[0]), this.exprs);
    }

    protected String toString(String sep) {
        return new TokenBuilder("(").addSep(this.exprs, sep).add(")").toString();
    }
}

