/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Unary
extends Single {
    private final boolean minus;

    public Unary(InputInfo info, Expr expr, boolean minus) {
        super(info, expr, SeqType.NUM_ZO);
        this.minus = minus;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        SeqType st = this.expr.seqType();
        Type type = st.type;
        this.exprType.assign(type.isUntyped() ? AtomType.DBL : (type.isNumber() ? type : AtomType.ITR), st.oneNoArray() ? Occ.ONE : Occ.ZERO_ONE);
        return !this.minus && st.instanceOf(SeqType.NUM_ZO) ? cc.replaceWith(this, this.expr) : (this.expr instanceof Value ? cc.preEval(this) : this);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.expr.atomItem(qc, this.info);
        if (item == null) {
            return null;
        }
        Type type = item.type;
        if (type.isUntyped()) {
            double d = item.dbl(this.info);
            return Dbl.get(this.minus ? -d : d);
        }
        if (!type.isNumber()) {
            throw QueryError.numberError(this, item);
        }
        if (!this.minus) {
            return item;
        }
        if (type == AtomType.DBL) {
            return Dbl.get(-item.dbl(this.info));
        }
        if (type == AtomType.FLT) {
            return Flt.get(-item.flt(this.info));
        }
        if (type == AtomType.DEC) {
            return Dec.get(item.dec(this.info).negate());
        }
        long l = item.itr(this.info);
        if (l == Long.MIN_VALUE) {
            throw QueryError.RANGE_X.get(this.info, item);
        }
        return Int.get(-l);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Unary(this.info, this.expr.copy(cc, vm), this.minus));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Unary && this.minus == ((Unary)obj).minus && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Unary.addPlan(plan, this.planElem("value", this.minus), this.expr);
    }

    @Override
    public String toString() {
        return (this.minus ? "-" : "") + this.expr;
    }
}

