/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.Util;

public final class NameTest
extends Test {
    public final byte[] local;
    private final byte[] defNS;

    public NameTest(boolean attr) {
        this(null, Test.Kind.WILDCARD, attr, null);
    }

    public NameTest(QNm name, Test.Kind kind, boolean attr, byte[] defNS) {
        super(attr ? NodeType.ATT : NodeType.ELM);
        this.name = name;
        this.kind = kind;
        this.defNS = defNS != null ? defNS : Token.EMPTY;
        this.local = name != null ? name.local() : null;
        this.one = kind == Test.Kind.URI_NAME;
    }

    @Override
    public boolean optimize(Value value) {
        if (value == null) {
            return true;
        }
        Data data = value.data();
        if (data == null) {
            return true;
        }
        byte[] dataNS = data.nspaces.globalUri();
        if (dataNS == null) {
            return true;
        }
        boolean results = true;
        if (this.kind == Test.Kind.URI_NAME && !this.name.hasURI()) {
            if (this.type == NodeType.ATT || Token.eq(dataNS, this.defNS)) {
                this.kind = Test.Kind.NAME;
            } else {
                results = false;
            }
        }
        if (results) {
            results = this.kind != Test.Kind.NAME || (this.type == NodeType.ELM ? data.elemNames : data.attrNames).contains(this.local);
        }
        return results;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean eq(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.kind) {
            case WILDCARD: {
                return true;
            }
            case NAME: {
                return Token.eq(this.local, Token.local(node.name()));
            }
            case URI: {
                return Token.eq(this.name.uri(), node.qname().uri());
            }
        }
        return this.type == NodeType.ATT && this.name.uri().length == 0 ? Token.eq(this.local, node.name()) : this.name.eq(node.qname());
    }

    public boolean eq(QNm nm) {
        switch (this.kind) {
            case WILDCARD: {
                return true;
            }
            case NAME: {
                return Token.eq(this.local, nm.local());
            }
            case URI: {
                return Token.eq(this.name.uri(), nm.uri());
            }
        }
        return this.name.eq(nm);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NameTest)) {
            return false;
        }
        NameTest nt = (NameTest)obj;
        if (this.kind != nt.kind) {
            return false;
        }
        switch (this.kind) {
            case WILDCARD: {
                return true;
            }
            case NAME: {
                return Token.eq(this.local, nt.local);
            }
            case URI: {
                return Token.eq(this.name.uri(), nt.name.uri());
            }
        }
        return this.name.eq(nt.name);
    }

    @Override
    public Test intersect(Test other) {
        throw Util.notExpected(other, new Object[0]);
    }

    @Override
    public String toString() {
        if (this.kind == Test.Kind.WILDCARD) {
            return "*";
        }
        if (this.kind == Test.Kind.NAME) {
            return "*:" + Token.string(this.name.string());
        }
        String uri = this.name.uri().length == 0 || this.name.hasPrefix() ? "" : '{' + Token.string(this.name.uri()) + '}';
        return uri + (this.kind == Test.Kind.URI ? "*" : Token.string(this.name.string()));
    }
}

