/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.admin;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.core.users.UserText;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.admin.AdminFn;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ElementNodes;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.node.FElem;
import org.basex.server.Log;
import org.basex.server.LogEntry;
import org.basex.server.LogFile;
import org.basex.util.Strings;
import org.basex.util.Token;

public final class AdminLogs
extends AdminFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        this.checkAdmin(qc);
        ValueBuilder vb = new ValueBuilder(qc);
        if (this.exprs.length == 0) {
            for (IOFile f : qc.context.log.files()) {
                String date = f.name().replace(".log", "");
                vb.add(new FElem("file").add(date).add("size", Token.token(f.length())));
            }
        } else {
            String name = Token.string(this.toToken(this.exprs[0], qc));
            boolean merge = this.exprs.length > 1 && this.toBoolean(this.exprs[1], qc);
            ElementNodes.NodeIterator iter = this.logs(name, qc).iterator();
            while (iter.hasNext()) {
                LogEntry l1 = (LogEntry)iter.next();
                FElem elem = new FElem("entry");
                if (l1.address != null) {
                    if (merge && l1.type.equals(Log.LogType.REQUEST.name())) {
                        ElementNodes.NodeIterator iter2 = iter.copy();
                        while (iter2.hasNext()) {
                            LogEntry l2 = (LogEntry)iter2.next();
                            if ((!l1.address.equals(l2.address) || !l2.type.matches("^\\d+$")) && !Strings.eq(l2.type, Log.LogType.OK.name(), Log.LogType.ERROR.name())) continue;
                            l1.type = l2.type;
                            l1.ms = l1.ms.add(l2.ms);
                            if (!l2.message.isEmpty()) {
                                l1.message = l1.message + "; " + l2.message;
                            }
                            iter2.remove();
                            break;
                        }
                    }
                    elem.add("time", l1.time).add("address", l1.address).add(UserText.USER, l1.user);
                    if (l1.type != null) {
                        elem.add("type", l1.type);
                    }
                    if (l1.ms.compareTo(BigDecimal.ZERO) != 0) {
                        elem.add("ms", l1.ms.toString());
                    }
                    if (l1.message != null) {
                        elem.add(l1.message);
                    }
                } else {
                    elem.add(l1.message);
                }
                vb.add(elem);
                qc.checkStop();
            }
        }
        return vb.value();
    }

    private ElementNodes<LogEntry> logs(String name, QueryContext qc) throws QueryException {
        Log log = qc.context.log;
        LogFile file = log.file(name);
        if (file == null) {
            throw QueryError.WHICHRES_X.get(this.info, name);
        }
        try {
            ElementNodes<LogEntry> logs = new ElementNodes<LogEntry>();
            for (String line : file.read()) {
                qc.checkStop();
                LogEntry entry = new LogEntry();
                String[] cols = line.split("\t");
                if (cols.length > 2) {
                    entry.time = cols[0];
                    entry.address = cols[1];
                    entry.user = cols[2];
                    entry.type = cols.length > 3 ? cols[3] : "";
                    entry.message = cols.length > 4 ? cols[4] : "";
                    entry.ms = cols.length > 5 ? new BigDecimal(cols[5].replace(" ms", "")) : BigDecimal.ZERO;
                } else {
                    entry.message = line;
                }
                logs.add(entry);
            }
            return logs;
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }
}

