/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnSort;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ArraySort
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] tok;
        Array array = this.toArray(this.exprs[0], qc);
        Collation coll = this.sc.collation;
        if (this.exprs.length > 1 && (tok = this.toTokenOrNull(this.exprs[1], qc)) != null) {
            coll = Collation.get(tok, qc, this.sc, this.info, QueryError.WHICHCOLL_X);
        }
        long size = array.arraySize();
        ValueList values = new ValueList(size);
        FItem key = this.exprs.length > 2 ? this.checkArity(this.exprs[2], 1, qc) : null;
        for (Value value : array.members()) {
            values.add((key == null ? value : key.invokeValue(qc, this.info, value)).atomValue(qc, this.info));
        }
        ArrayBuilder builder = new ArrayBuilder();
        Integer[] integerArray = FnSort.sort(values, this, coll, qc);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int order = integerArray[i];
            builder.append(array.get(order));
        }
        return builder.freeze();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqType st1 = this.exprs[0].seqType();
        Type type1 = st1.type;
        if (type1 instanceof ArrayType) {
            if (this.exprs.length == 3) {
                this.coerceFunc(2, cc, SeqType.AAT_ZM, ((ArrayType)type1).declType);
            }
            this.exprType.assign(type1);
        }
        return this;
    }
}

