/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.name;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Optimize;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBNew;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.name.NameUpdate;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.options.Options;

public final class DBCreate
extends NameUpdate {
    private final DBNew newDocs;
    private final DBOptions options;

    public DBCreate(String name, NewInput[] inputs, Options opts, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBCREATE, name, info, qc);
        ArrayList supported = new ArrayList();
        Collections.addAll(supported, DBOptions.INDEXING);
        Collections.addAll(supported, DBOptions.PARSING);
        this.options = new DBOptions(opts, supported, info);
        this.newDocs = new DBNew(qc, this.options, info, inputs);
    }

    @Override
    public void prepare() throws QueryException {
        this.newDocs.prepare(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() throws QueryException {
        try {
            this.close();
            MainOptions mopts = this.options.assignTo(new MainOptions(this.qc.context.options, true));
            Data data = CreateDB.create(this.name, Parser.emptyParser(mopts), this.qc.context, mopts);
            Data newData = this.newDocs.data;
            if (newData != null) {
                data.startUpdate(mopts);
                try {
                    data.insert(data.meta.size, -1, new DataClip(newData));
                    Optimize.optimize(data, null);
                }
                finally {
                    data.finishUpdate(mopts);
                }
            }
            Close.close(data, this.qc.context);
        }
        catch (IOException ex) {
            throw QueryError.UPDBOPTERR_X.get(this.info, ex);
        }
        finally {
            this.newDocs.finish();
        }
    }

    public String toString() {
        return Util.className(this) + '[' + this.newDocs.inputs + ']';
    }

    @Override
    public String operation() {
        return "created";
    }
}

