/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Hex
extends Bin {
    public Hex(byte[] value) {
        super(value, AtomType.HEX);
    }

    public Hex(byte[] value, InputInfo info) throws QueryException {
        super(Hex.parse(Token.trim(value), info), AtomType.HEX);
    }

    public Hex(Bin bin, InputInfo info) throws QueryException {
        this(bin.binary(info));
    }

    @Override
    public byte[] string(InputInfo info) throws QueryException {
        return Token.hex(this.binary(info), true);
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(info) : Hex.parse(item, info);
        return Token.eq(this.binary(info), bin);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(info) : Hex.parse(item, info);
        return Token.diff(this.binary(info), bin);
    }

    public static byte[] parse(Item item, InputInfo info) throws QueryException {
        byte[] bytes = Hex.parse(item.string(info));
        if (bytes != null) {
            return bytes;
        }
        throw AtomType.HEX.castError(item, info);
    }

    public static byte[] parse(byte[] value, InputInfo info) throws QueryException {
        byte[] bytes = Hex.parse(value);
        if (bytes != null) {
            return bytes;
        }
        throw AtomType.HEX.castError(value, info);
    }

    private static byte[] parse(byte[] data) {
        int dl = data.length;
        if ((dl & 1) != 0) {
            return null;
        }
        byte[] value = new byte[dl >>> 1];
        for (int d = 0; d < dl; d += 2) {
            int n = Token.dec(data[d], data[d + 1]);
            if (n < 0) {
                return null;
            }
            value[d >>> 1] = (byte)n;
        }
        return value;
    }

    @Override
    public String toString() {
        return new TokenBuilder().add(34).add(Token.hex(this.data, true)).add(34).toString();
    }
}

