/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Uln
extends ANum {
    public static final BigDecimal MAXULN = BigDecimal.valueOf(Long.MAX_VALUE).multiply(BigDecimal.valueOf(2L)).add(BigDecimal.ONE);
    private final BigInteger value;

    private Uln(BigInteger value) {
        super(AtomType.ULN);
        this.value = value;
    }

    public static Uln get(BigInteger value) {
        return new Uln(value);
    }

    @Override
    public byte[] string() {
        return Token.token(this.value.toString());
    }

    @Override
    public boolean bool(InputInfo info) {
        return this.value.signum() != 0;
    }

    @Override
    public long itr() {
        return this.value.longValue();
    }

    @Override
    public float flt() {
        return this.value.floatValue();
    }

    @Override
    public double dbl() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo info) {
        return new BigDecimal(this.value);
    }

    @Override
    public ANum abs() {
        long l = this.itr();
        return l >= 0L ? this : Int.get(-l);
    }

    @Override
    public Uln ceiling() {
        return this;
    }

    @Override
    public Uln floor() {
        return this;
    }

    @Override
    public ANum round(int scale, boolean even) {
        return scale >= 0 ? this : Int.get(Dec.get(new BigDecimal(this.value)).round(scale, even).dec(null).longValue());
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        return item.type == AtomType.ULN ? this.value.equals(((Uln)item).value) : (item.type == AtomType.DBL || item.type == AtomType.FLT ? item.eq(this, coll, sc, info) : this.value.compareTo(BigInteger.valueOf(item.itr(info))) == 0);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        if (item.type == AtomType.ULN) {
            return this.value.compareTo(((Uln)item).value);
        }
        if (item.type == AtomType.DBL || item.type == AtomType.FLT) {
            return -item.diff(this, coll, info);
        }
        return this.value.compareTo(BigInteger.valueOf(item.itr(info)));
    }

    @Override
    public Object toJava() {
        return new BigInteger(this.value.toString());
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Uln && this.value.compareTo(((Uln)obj).value) == 0;
    }
}

