/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Locale;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Strings {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16BE = "UTF-16BE";
    public static final String UTF16LE = "UTF-16LE";
    public static final String UTF32 = "UTF-32";
    public static final String ISO88591 = "ISO-8859-1";
    private static final String[] ALL_UTF8 = new String[]{"UTF-8", "UTF8"};
    private static final String[] ALL_UTF16 = new String[]{"UTF-16", "UTF16"};
    private static final String[] ALL_UTF32 = new String[]{"UTF-32", "UTF32"};

    private Strings() {
    }

    public static long toLong(String string) {
        return Token.toLong(Token.token(string));
    }

    public static int toInt(String string) {
        return Token.toInt(Token.token(string));
    }

    public static boolean eq(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean eq(String str, String ... strings) {
        for (String s : strings) {
            if (!(str == null ? s == null : str.equals(s))) continue;
            return true;
        }
        return false;
    }

    public static boolean eqic(String str, String ... strings) {
        for (String s : strings) {
            if (!(str == null ? s == null : str.equalsIgnoreCase(s))) continue;
            return true;
        }
        return false;
    }

    public static String[] split(String string, char sep) {
        return Strings.split(string, sep, Integer.MAX_VALUE);
    }

    public static String[] split(String string, char sep, int limit) {
        StringList sl = new StringList(limit == Integer.MAX_VALUE ? 8 : limit);
        int tl = string.length();
        int s = 0;
        int c = 1;
        for (int p = 0; p < tl && c < limit; ++p) {
            if (string.charAt(p) != sep) continue;
            sl.add(string.substring(s, p));
            s = p + 1;
            ++c;
        }
        sl.add(string.substring(s, tl));
        return (String[])sl.finish();
    }

    public static String delete(String string, char ch) {
        if (!Strings.contains(string, ch)) {
            return string;
        }
        int tl = string.length();
        StringBuilder sb = new StringBuilder(tl - 1);
        for (int p = 0; p < tl; ++p) {
            char c = string.charAt(p);
            if (c == ch) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean contains(String string, char ch) {
        return string.indexOf(ch) != -1;
    }

    public static String md5(String string) {
        return Strings.hash(string, "MD5");
    }

    public static String sha256(String string) {
        return Strings.hash(string, "SHA-256");
    }

    private static String hash(String string, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            return Token.string(Token.hex(md.digest(Token.token(string)), false));
        }
        catch (Exception ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    public static String normEncoding(String encoding) {
        return Strings.normEncoding(encoding, false);
    }

    public static String normEncoding(String encoding, boolean utf16) {
        if (encoding == null) {
            return UTF8;
        }
        String e = encoding.toUpperCase(Locale.ENGLISH);
        if (Strings.eq(e, ALL_UTF8)) {
            return UTF8;
        }
        if (e.equals(UTF16LE)) {
            return UTF16LE;
        }
        if (e.equals(UTF16BE)) {
            return UTF16BE;
        }
        if (Strings.eq(e, ALL_UTF16)) {
            return utf16 ? UTF16BE : UTF16;
        }
        if (Strings.eq(e, ALL_UTF32)) {
            return UTF32;
        }
        return encoding;
    }

    public static boolean supported(String encoding) {
        try {
            return Charset.isSupported(encoding);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean yes(String string) {
        return Strings.eqic(string, "true", "yes", "ON", "1");
    }

    public static String capitalize(String string) {
        StringBuilder sb = new StringBuilder();
        if (!string.isEmpty()) {
            sb.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1));
        }
        return sb.toString();
    }

    public static String className(String string) {
        String s = string.replace('/', '.');
        int c = s.lastIndexOf(46) + 1;
        return s.substring(0, c) + Strings.capitalize(Strings.camelCase(s.substring(c)));
    }

    public static String camelCase(String string) {
        StringBuilder sb = new StringBuilder();
        boolean upper = false;
        int sl = string.length();
        for (int s = 0; s < sl; ++s) {
            char ch = string.charAt(s);
            if (ch == '-') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(ch));
                upper = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static boolean no(String string) {
        return Strings.eqic(string, "false", "no", "OFF", "0");
    }

    public static String uri2path(String uri) {
        String path = uri;
        try {
            URI u = new URI(uri);
            TokenBuilder tb = new TokenBuilder();
            if (u.isOpaque()) {
                tb.add(u.getScheme()).add(47).add(u.getSchemeSpecificPart().replace(':', '/'));
            } else {
                String p;
                String auth = u.getAuthority();
                if (auth != null) {
                    String[] comp = Strings.split(auth, '.');
                    for (int c = comp.length - 1; c >= 0; --c) {
                        tb.add(47).add(comp[c]);
                    }
                }
                tb.add((p = u.getPath()) == null || p.isEmpty() ? "/" : p.replace('.', '/'));
            }
            path = tb.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        path = path.replaceAll("[^\\w.-/]+", "-").replaceAll("//+", "/");
        if (path.endsWith("/")) {
            path = path + "index";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static boolean startsWith(String string, String sub) {
        int sl = string.length();
        int tl = sub.length();
        if (tl > sl) {
            return false;
        }
        for (int t = 0; t < tl; ++t) {
            if (Strings.equals(string.charAt(t), sub.charAt(t))) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(String string, String sub) {
        int tl = sub.length();
        if (tl == 0) {
            return true;
        }
        int sl = string.length() - tl;
        for (int s = 0; s <= sl; ++s) {
            int t = 0;
            while (Strings.equals(string.charAt(s + t), sub.charAt(t))) {
                if (++t != tl) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(String string, String sub) {
        int sl = string.length();
        int tl = sub.length();
        int t = 0;
        for (int s = 0; s < sl && t < tl; ++s) {
            if (!Strings.equals(string.charAt(s), sub.charAt(t))) continue;
            ++t;
        }
        return t == tl;
    }

    private static boolean equals(char input, char query) {
        return query == (Character.isUpperCase(query) ? input : Character.toLowerCase(input));
    }
}

