/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.datasync;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.datasync.ComparatorFactory;
import org.directwebremoting.io.SortCriterion;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortCriteriaComparator<T>
implements Comparator<T> {
    private final ComparatorFactory<T> comparatorFactory;
    private final List<SortCriterion> sort;
    private static final Log log = LogFactory.getLog(SortCriteriaComparator.class);

    public SortCriteriaComparator(List<SortCriterion> sort, ComparatorFactory<T> comparatorFactory) {
        this.sort = sort;
        this.comparatorFactory = comparatorFactory;
    }

    @Override
    public int compare(T object1, T object2) {
        if (object1 == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object1.getClass() != object2.getClass()) {
            log.warn((Object)("Classes don't match. Results could be unpredictable: " + object1.getClass() + " / " + object2.getClass()));
        }
        try {
            for (SortCriterion criterion : this.sort) {
                Comparator<T> comparator = this.comparatorFactory.getComparator(criterion.getAttribute(), criterion.isAscending());
                int comparison = comparator.compare(object1, object2);
                if (comparison == 0) continue;
                return comparison;
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failure while sorting objects", (Throwable)ex);
        }
        if (object1.equals(object2)) {
            return 0;
        }
        int hash1 = object1.hashCode();
        int hash2 = object2.hashCode();
        return LocalUtil.shrink(hash1 - hash2);
    }
}

