/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.Sleeper;

public class HtmlScriptConduit
extends BaseScriptConduit {
    public HtmlScriptConduit(Sleeper sleeper, HttpServletResponse response, String instanceId, String batchId, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        super(sleeper, response, instanceId, batchId, converterManager, jsonOutput);
    }

    protected String getOutboundMimeType() {
        return "text/html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginStream() {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println("<html><body>");
            this.out.println("<script type=\"text/javascript\">");
            this.out.print(EnginePrivate.remoteBeginWrapper(this.instanceId, true));
            this.out.println(EnginePrivate.remoteBeginIFrameResponse(this.batchId, true));
            this.out.print(EnginePrivate.remoteEndWrapper(this.instanceId, true));
            this.out.println("</script>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endStream() {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println("<script type=\"text/javascript\">");
            this.out.print(EnginePrivate.remoteBeginWrapper(this.instanceId, true));
            this.out.println(EnginePrivate.remoteEndIFrameResponse(this.batchId, true));
            this.out.print(EnginePrivate.remoteEndWrapper(this.instanceId, true));
            this.out.println("</script>");
            this.out.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addScript(ScriptBuffer scriptBuffer) throws IOException, ConversionException {
        String script = ScriptBufferUtil.createOutput(scriptBuffer, this.converterManager, this.jsonOutput);
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println("<script type=\"text/javascript\">");
            this.out.print(EnginePrivate.remoteBeginWrapper(this.instanceId, true));
            this.out.println(EnginePrivate.remoteEval(script));
            this.out.print(EnginePrivate.remoteEndWrapper(this.instanceId, true));
            this.out.println("</script>");
            return this.flush();
        }
    }
}

